/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import thut.api.TickHandler;
import thut.api.block.IOwnableTE;
import thut.api.entity.ai.AIThreadManager;
import thut.api.entity.ai.IAIMob;
import thut.api.entity.genetics.Alleles;
import thut.api.entity.genetics.IMobGenetics;
import thut.api.maths.Cruncher;
import thut.api.network.PacketHandler;
import thut.api.terrain.BiomeDatabase;
import thut.api.terrain.TerrainManager;
import thut.core.common.CommonProxy;
import thut.core.common.CreativeTabThut;
import thut.core.common.commands.ConfigCommand;
import thut.core.common.genetics.DefaultGenetics;
import thut.core.common.handlers.ConfigHandler;
import thut.core.common.handlers.PlayerDataHandler;

@Mod(modid="thutcore", name="ThutCore", version="4.4.2", updateJSON="https://raw.githubusercontent.com/Thutmose/Thut/master/ThutCore/versions.json", guiFactory="thut.core.client.config.ModGuiFactory", acceptedMinecraftVersions="[1.11.2]")
public class ThutCore {
    @SidedProxy(clientSide="thut.core.client.ClientProxy", serverSide="thut.core.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="thutcore")
    public static ThutCore instance;
    public static final String modid = "thutcore";
    public static CreativeTabThut tabThut;
    public static Block[] blocks;
    public static Item[] items;
    public static Biome volcano;
    public static Biome chalk;
    public ConfigHandler config;

    public ThutCore() {
        BiomeDatabase.getNameFromType(0);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        proxy.initClient();
        proxy.registerEntities();
        proxy.registerTEs();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        proxy.preinit(e);
        this.config = new ConfigHandler(e.getSuggestedConfigurationFile());
        proxy.loadSounds();
        AIThreadManager.AIThread.threadCount = this.config.threadCount;
        AIThreadManager.AIThread.createThreads();
        AIThreadManager aiTicker = new AIThreadManager();
        MinecraftForge.EVENT_BUS.register((Object)aiTicker);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler());
        new Cruncher();
        CapabilityManager.INSTANCE.register(IAIMob.class, (Capability.IStorage)new Capability.IStorage<IAIMob>(){

            public NBTBase writeNBT(Capability<IAIMob> capability, IAIMob instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IAIMob> capability, IAIMob instance, EnumFacing side, NBTBase nbt) {
            }
        }, new IAIMob(){

            @Override
            public AIThreadManager.AIStuff getAI() {
                return null;
            }

            @Override
            public boolean selfManaged() {
                return true;
            }
        }.getClass());
        CapabilityManager.INSTANCE.register(IMobGenetics.class, (Capability.IStorage)new Capability.IStorage<IMobGenetics>(){

            public NBTBase writeNBT(Capability<IMobGenetics> capability, IMobGenetics instance, EnumFacing side) {
                NBTTagList genes = new NBTTagList();
                for (Map.Entry<ResourceLocation, Alleles> entry : instance.getAlleles().entrySet()) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("K", entry.getKey().toString());
                    tag.func_74782_a("V", (NBTBase)entry.getValue().save());
                    genes.func_74742_a((NBTBase)tag);
                }
                return genes;
            }

            public void readNBT(Capability<IMobGenetics> capability, IMobGenetics instance, EnumFacing side, NBTBase nbt) {
                NBTTagList list = (NBTTagList)nbt;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    Alleles alleles = new Alleles();
                    ResourceLocation key = new ResourceLocation(tag.func_74779_i("K"));
                    try {
                        alleles.load(tag.func_74775_l("V"));
                        instance.getAlleles().put(key, alleles);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Error with " + key);
                    }
                }
            }
        }, DefaultGenetics.class);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ConfigCommand());
        TerrainManager.getInstance();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStoppedEvent event) {
        TerrainManager.clear();
        PlayerDataHandler.clear();
        AIThreadManager.clear();
    }

    @SubscribeEvent
    public void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        PacketHandler.sendTerrainValues((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void BreakBlock(BlockEvent.BreakEvent evt) {
        EntityPlayer player = evt.getPlayer();
        TileEntity tile = evt.getWorld().func_175625_s(evt.getPos());
        if (tile instanceof IOwnableTE) {
            IOwnableTE te = (IOwnableTE)tile;
            NBTTagCompound tag = tile.func_189515_b(new NBTTagCompound());
            if (tag.func_74764_b("admin") && tag.func_74767_n("admin") && !te.canEdit((Entity)player)) {
                evt.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void ExplosionEvent(ExplosionEvent.Detonate evt) {
        ArrayList toRemove = Lists.newArrayList();
        for (BlockPos pos : evt.getAffectedBlocks()) {
            NBTTagCompound tag;
            TileEntity tile = evt.getWorld().func_175625_s(pos);
            if (!(tile instanceof IOwnableTE) || !(tag = tile.func_189515_b(new NBTTagCompound())).func_74764_b("admin") || !tag.func_74767_n("admin")) continue;
            toRemove.add(pos);
        }
        evt.getAffectedBlocks().removeAll(toRemove);
    }

    static {
        tabThut = CreativeTabThut.tabThut;
    }
}

