/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import scala.actors.threadpool.Arrays;
import thut.core.common.ThutCore;
import thut.core.common.config.Configure;
import thut.core.common.handlers.ConfigHandler;

public class ConfigCommand
extends CommandBase {
    private List<String> aliases;
    ArrayList<String> fields = Lists.newArrayList();
    HashMap<String, Field> fieldMap = Maps.newHashMap();

    public ConfigCommand() {
        this.aliases = new ArrayList<String>();
        this.aliases.add("thutcoresettings");
        this.populateFields();
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean op = ConfigCommand.isOp(sender);
        if (args.length == 0) {
            throw new CommandException("arguments error, press tab for options", new Object[0]);
        }
        boolean check = args.length <= 1;
        Field field = this.fieldMap.get(args[0]);
        if (field == null) {
            throw new CommandException("arguments error, press tab for options", new Object[0]);
        }
        try {
            String text = "";
            Object o = field.get((Object)ThutCore.instance.config);
            text = o instanceof String[] ? text + Arrays.toString((Object[])((Object[])o)) : (o instanceof int[] ? text + Arrays.toString((int[])((int[])o)) : text + o);
            TextComponentTranslation mess = new TextComponentTranslation("thutcore.command.settings.check", new Object[]{args[0], text});
            if (check) {
                sender.func_145747_a((ITextComponent)mess);
                return;
            }
            if (!op) {
                throw new CommandException("No permission to do that", new Object[0]);
            }
            try {
                String val = args[1];
                if (args.length > 2) {
                    for (int i = 2; i < args.length; ++i) {
                        val = val + " " + args[i];
                    }
                }
                ThutCore.instance.config.updateField(field, val);
            }
            catch (Exception e) {
                throw new CommandException("invalid options", new Object[0]);
            }
            text = "";
            o = field.get((Object)ThutCore.instance.config);
            text = o instanceof String[] ? text + Arrays.toString((Object[])((Object[])o)) : (o instanceof int[] ? text + Arrays.toString((int[])((int[])o)) : text + o);
            mess = new TextComponentTranslation("thutcore.command.settings.set", new Object[]{args[0], text});
            sender.func_145747_a((ITextComponent)mess);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException("unknown error", new Object[0]);
        }
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public String func_71517_b() {
        return this.aliases.get(0);
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.aliases.get(0) + "<option name> <optional:newvalue>";
    }

    public int func_82362_a() {
        return 4;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> ret = new ArrayList<String>();
        if (args.length == 1) {
            String text = args[0];
            for (String name : this.fields) {
                if (!name.contains(text)) continue;
                ret.add(name);
            }
            Collections.sort(ret, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
        }
        return ret;
    }

    private void populateFields() {
        Class<ConfigHandler> me = ConfigHandler.class;
        for (Field f : me.getDeclaredFields()) {
            Configure c = f.getAnnotation(Configure.class);
            if (c == null) continue;
            f.setAccessible(true);
            this.fields.add(f.getName());
            this.fieldMap.put(f.getName(), f);
        }
    }

    public static boolean isOp(ICommandSender sender) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S()) {
            return true;
        }
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = sender.func_130014_f_().func_72924_a(sender.func_70005_c_());
            UserListOpsEntry userentry = (UserListOpsEntry)((EntityPlayerMP)player).field_71133_b.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
            return userentry != null && userentry.func_152644_a() >= 4;
        }
        if (sender instanceof TileEntityCommandBlock) {
            return true;
        }
        return sender.func_70005_c_().equalsIgnoreCase("@") || sender.func_70005_c_().equals("Server");
    }
}

