/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.handlers;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import thut.api.boom.ExplosionCustom;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.terrain.TerrainSegment;
import thut.core.common.config.ConfigBase;
import thut.core.common.config.Configure;

public class ConfigHandler
extends ConfigBase {
    private static final String BOOMS = "explosions";
    private static final String BIOMES = "biomes";
    private static final String BLOCKENTITY = "blockentity";
    private static final String AI = "ai";
    @Configure(category="explosions")
    private int explosionRadius = 127;
    @Configure(category="explosions")
    private int[] explosionRate = new int[]{2000, 10000};
    @Configure(category="explosions")
    private boolean affectAir = true;
    @Configure(category="explosions")
    private double minBlastEffect = 0.25;
    @Configure(category="biomes")
    public boolean resetAllTerrain = false;
    @Configure(category="ai", needsMcRestart=true)
    public int threadCount = 1;
    @Configure(category="blockentity")
    private String[] whitelist = new String[]{"Chest", "DLDetector", "FlowerPot", "EnchantTable", "warppad", "Comparator", "pokecube:pokecube_table", "tradingtable", "EndGateway", "Control", "Piston", "pokecenter", "EnderChest", "MobSpawner", "cloner", "pokecube:berries", "Airportal", "Banner", "Trap", "Furnace", "Dropper", "Cauldron", "repel", "pc", "Music", "multiblockpart", "multiblockpartfluids", "Beacon", "Skull", "Hopper", "Sign", "pokesiphon", "pokemobnest", "RecordPlayer"};

    public ConfigHandler() {
        super(null);
    }

    public ConfigHandler(File configFile) {
        super(configFile, new ConfigHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.populateSettings();
        this.applySettings();
        this.save();
    }

    @Override
    protected void applySettings() {
        ExplosionCustom.MAX_RADIUS = this.explosionRadius;
        ExplosionCustom.AFFECTINAIR = this.affectAir;
        if (this.explosionRate.length == 2) {
            ExplosionCustom.MAXPERTICK = this.explosionRate;
        }
        ExplosionCustom.MINBLASTDAMAGE = (float)this.minBlastEffect;
        TerrainSegment.noLoad = this.resetAllTerrain;
        IBlockEntity.TEWHITELIST.clear();
        for (String s : this.whitelist) {
            IBlockEntity.TEWHITELIST.add(s);
        }
    }
}

