/*
 * Decompiled with CFR 0.152.
 */
package thut.lib;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import thut.lib.CompatClass;

public class CompatParser {
    public static void findClasses(String classPackage, Map<CompatClass.Phase, Set<Method>> initMethods) {
        try {
            List<Class<?>> foundClasses = ClassFinder.find(classPackage);
            for (Class<?> c : foundClasses) {
                try {
                    CompatClass comp = null;
                    for (Method m : c.getMethods()) {
                        comp = m.getAnnotation(CompatClass.class);
                        if (comp == null) continue;
                        initMethods.get((Object)comp.phase()).add(m);
                    }
                }
                catch (Throwable e) {
                    System.err.println("Error with " + c);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static class ClassFinder {
        private static final char DOT = '.';
        private static final char SLASH = '/';
        private static final String CLASS_SUFFIX = ".class";
        private static final String BAD_PACKAGE_ERROR = "Unable to get resources from path '%s'. Are you sure the package '%s' exists?";

        public static List<Class<?>> find(String scannedPackage) throws UnsupportedEncodingException {
            ArrayList classes;
            block8: {
                File scannedDir;
                block7: {
                    String scannedPath = scannedPackage.replace('.', '/');
                    URL scannedUrl = Thread.currentThread().getContextClassLoader().getResource(scannedPath);
                    if (scannedUrl == null) {
                        throw new IllegalArgumentException(String.format(BAD_PACKAGE_ERROR, scannedPath, scannedPackage));
                    }
                    scannedDir = new File(URLDecoder.decode(scannedUrl.getFile(), Charset.defaultCharset().name()));
                    classes = new ArrayList();
                    if (!scannedDir.exists()) break block7;
                    for (File file : scannedDir.listFiles()) {
                        classes.addAll(ClassFinder.findInFolder(file, scannedPackage));
                    }
                    break block8;
                }
                if (!scannedDir.toString().contains("file:") || !scannedDir.toString().contains(".jar")) break block8;
                String name = scannedDir.toString();
                String pack = name.split("!")[1].replace(File.separatorChar, '/').substring(1) + '/';
                name = name.replace("file:", "");
                name = name.replaceAll("(.jar)(.*)", ".jar");
                scannedDir = new File(name);
                try {
                    ZipFile zip = new ZipFile(scannedDir);
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    int n = 0;
                    while (entries.hasMoreElements() && n < 10) {
                        ZipEntry entry = entries.nextElement();
                        String s = entry.getName();
                        if (!s.contains(pack) || !s.endsWith(CLASS_SUFFIX)) continue;
                        try {
                            classes.add(Class.forName(s.replace(CLASS_SUFFIX, "").replace('/', '.')));
                        }
                        catch (Throwable throwable) {}
                    }
                    zip.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            return classes;
        }

        private static List<Class<?>> findInFolder(File file, String scannedPackage) {
            ArrayList classes;
            block4: {
                String resource;
                block3: {
                    classes = new ArrayList();
                    resource = scannedPackage + '.' + file.getName();
                    if (!file.isDirectory()) break block3;
                    for (File child : file.listFiles()) {
                        classes.addAll(ClassFinder.findInFolder(child, resource));
                    }
                    break block4;
                }
                if (!resource.endsWith(CLASS_SUFFIX)) break block4;
                int endIndex = resource.length() - CLASS_SUFFIX.length();
                String className = resource.substring(0, endIndex);
                try {
                    classes.add(Class.forName(className));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return classes;
        }
    }
}

