/*
 * Decompiled with CFR 0.152.
 */
package thut.api;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.IOwnable;
import thut.api.block.IOwnableTE;

public class OwnableCaps {
    public static final Set<Class<? extends LivingEntity>> MOBS = Sets.newHashSet();
    public static final Set<Class<? extends TileEntity>> TILES = Sets.newHashSet();
    private static final ResourceLocation LOCBASE = new ResourceLocation("thutcore:ownable_base");
    public static final ResourceLocation LOCWRAP = new ResourceLocation("thutcore:ownable_wrap");
    public static final ResourceLocation STICKTAG = new ResourceLocation("thutcore:pokeystick");
    @CapabilityInject(value=IOwnable.class)
    public static final Capability<IOwnable> CAPABILITY = null;

    public static IOwnable getOwnable(ICapabilityProvider in) {
        if (in == null) {
            return null;
        }
        return (IOwnable)in.getCapability(CAPABILITY).orElse(null);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void attachMobs(AttachCapabilitiesEvent<Entity> event) {
        if (!event.getCapabilities().containsKey(LOCWRAP)) {
            if (event.getObject() instanceof TameableEntity) {
                event.addCapability(LOCWRAP, (ICapabilityProvider)new TameWrapper((TameableEntity)event.getObject()));
            } else if (event.getObject() instanceof AbstractHorseEntity) {
                event.addCapability(LOCWRAP, (ICapabilityProvider)new HorseWrapper((AbstractHorseEntity)event.getObject()));
            }
        } else if (MOBS.contains(((Entity)event.getObject()).getClass())) {
            event.addCapability(LOCBASE, (ICapabilityProvider)new Impl());
        }
    }

    @SubscribeEvent
    public static void attachTEs(AttachCapabilitiesEvent<TileEntity> event) {
        if (TILES.contains(((TileEntity)event.getObject()).getClass())) {
            event.addCapability(LOCBASE, (ICapabilityProvider)new ImplTE());
        }
    }

    @SubscribeEvent
    public static void onblockPlace(BlockEvent.EntityPlaceEvent event) {
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (tile != null && event.getEntity() instanceof LivingEntity) {
            IOwnable ownable = (IOwnable)tile.getCapability(CAPABILITY).orElse(null);
            if (ownable instanceof IOwnableTE) {
                ((IOwnableTE)ownable).setPlacer((LivingEntity)event.getEntity());
            } else if (ownable != null) {
                ownable.setOwner((LivingEntity)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockHit(PlayerInteractEvent.LeftClickBlock event) {
        IOwnable ownable;
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (tile != null && (ownable = (IOwnable)tile.getCapability(CAPABILITY).orElse(null)) instanceof IOwnableTE && ((IOwnableTE)ownable).canEdit(event.getEntityLiving()) && ItemTags.func_199903_a().func_199915_b(STICKTAG).func_199685_a_((Object)event.getItemStack().func_77973_b())) {
            event.getWorld().func_175655_b(event.getPos(), true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        IOwnable ownable;
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (tile != null && (ownable = (IOwnable)tile.getCapability(CAPABILITY).orElse(null)) instanceof IOwnableTE && !((IOwnableTE)ownable).canEdit((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static void setup() {
        CapabilityManager.INSTANCE.register(IOwnable.class, (Capability.IStorage)new Storage(), Impl::new);
        MinecraftForge.EVENT_BUS.register(OwnableCaps.class);
    }

    public static class Storage
    implements Capability.IStorage<IOwnable> {
        public void readNBT(Capability<IOwnable> capability, IOwnable instance, Direction side, INBT nbt) {
            if (instance instanceof ICapabilitySerializable) {
                ((ICapabilitySerializable)instance).deserializeNBT(nbt);
            }
        }

        public INBT writeNBT(Capability<IOwnable> capability, IOwnable instance, Direction side) {
            if (instance instanceof ICapabilitySerializable) {
                return ((ICapabilitySerializable)instance).serializeNBT();
            }
            return null;
        }
    }

    public static class ImplTE
    extends Impl
    implements IOwnableTE {
    }

    public static class Impl
    implements IOwnable,
    ICapabilitySerializable<CompoundNBT> {
        private final LazyOptional<IOwnable> holder = LazyOptional.of(() -> this);
        private UUID ownerId;
        private LivingEntity ownerMob;
        private boolean playerOwned = false;

        public void deserializeNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b("p")) {
                this.playerOwned = nbt.func_74767_n("p");
                this.ownerId = nbt.func_186857_a("o");
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.holder);
        }

        @Override
        public LivingEntity getOwner() {
            return this.ownerMob;
        }

        @Override
        public UUID getOwnerId() {
            return this.ownerId;
        }

        @Override
        public boolean isPlayerOwned() {
            return this.playerOwned;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            if (this.ownerId != null) {
                nbt.func_186854_a("o", this.ownerId);
                nbt.func_74757_a("p", this.playerOwned);
            }
            return nbt;
        }

        @Override
        public void setOwner(LivingEntity e) {
            this.playerOwned = e instanceof PlayerEntity;
            this.ownerMob = e;
            if (e != null) {
                this.setOwner(e.func_110124_au());
            } else {
                this.setOwner((UUID)null);
            }
        }

        @Override
        public void setOwner(UUID id) {
            this.ownerId = id;
        }
    }

    public static class TameWrapper
    extends VanillaWrapper<TameableEntity> {
        LivingEntity owner = null;

        public TameWrapper(TameableEntity toWrap) {
            super(toWrap);
            this.playerOwned = toWrap.func_70902_q() instanceof PlayerEntity;
            if (!this.playerOwned && toWrap.func_184753_b() != null && toWrap.func_184102_h() != null) {
                this.playerOwned = toWrap.func_184102_h().func_152358_ax().func_152652_a(this.getOwnerId()) != null;
            }
        }

        @Override
        public LivingEntity getOwner() {
            if (this.getOwnerId() == null) {
                this.owner = null;
            }
            if (this.getOwnerId() != null && this.owner == null) {
                this.owner = ((TameableEntity)this.wrapped).func_70902_q();
            }
            if (this.getOwnerId() != null && this.owner == null && ((TameableEntity)this.wrapped).func_130014_f_() instanceof ServerWorld) {
                this.owner = this.getOwner((ServerWorld)((TameableEntity)this.wrapped).func_130014_f_(), this.owner);
                return this.owner;
            }
            return this.owner;
        }

        @Override
        public UUID getOwnerId() {
            return ((TameableEntity)this.wrapped).func_184753_b();
        }

        @Override
        public boolean isPlayerOwned() {
            return this.playerOwned;
        }

        @Override
        public void setOwner(LivingEntity e) {
            this.setOwner(e == null ? null : e.func_110124_au());
            this.owner = e;
            this.playerOwned = e instanceof PlayerEntity;
        }

        @Override
        public void setOwner(UUID id) {
            ((TameableEntity)this.wrapped).func_184754_b(id);
            ((TameableEntity)this.wrapped).func_70903_f(id != null);
        }
    }

    public static class HorseWrapper
    extends VanillaWrapper<AbstractHorseEntity> {
        LivingEntity owner;

        public HorseWrapper(AbstractHorseEntity toWrap) {
            super(toWrap);
            if (!this.playerOwned && toWrap.func_184780_dh() != null && toWrap.func_184102_h() != null) {
                this.playerOwned = toWrap.func_184102_h().func_152358_ax().func_152652_a(this.getOwnerId()) != null;
            }
        }

        @Override
        public LivingEntity getOwner() {
            if (this.getOwnerId() == null) {
                this.owner = null;
            }
            if (this.getOwnerId() != null && this.owner == null && ((AbstractHorseEntity)this.wrapped).func_130014_f_() instanceof ServerWorld) {
                this.owner = this.getOwner((ServerWorld)((AbstractHorseEntity)this.wrapped).func_130014_f_(), this.owner);
                return this.owner;
            }
            return this.owner;
        }

        @Override
        public UUID getOwnerId() {
            return ((AbstractHorseEntity)this.wrapped).func_184780_dh();
        }

        @Override
        public boolean isPlayerOwned() {
            return this.playerOwned;
        }

        @Override
        public void setOwner(LivingEntity e) {
            this.owner = e;
            ((AbstractHorseEntity)this.wrapped).func_184779_b(e == null ? null : e.func_110124_au());
        }

        @Override
        public void setOwner(UUID id) {
            ((AbstractHorseEntity)this.wrapped).func_184779_b(id);
        }
    }

    public static abstract class VanillaWrapper<M extends MobEntity>
    implements IOwnable,
    ICapabilitySerializable<ByteNBT> {
        private final LazyOptional<IOwnable> holder = LazyOptional.of(() -> this);
        boolean playerOwned = false;
        protected final M wrapped;

        public VanillaWrapper(M toWrap) {
            this.wrapped = toWrap;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.holder);
        }

        public ByteNBT serializeNBT() {
            ByteNBT tag = new ByteNBT((byte)(this.playerOwned ? 1 : 0));
            return tag;
        }

        public void deserializeNBT(ByteNBT nbt) {
            this.playerOwned = nbt.func_150290_f() != 0;
        }
    }
}

