/*
 * Decompiled with CFR 0.152.
 */
package thut.api.boom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import thut.api.boom.ExplosionCustom;
import thut.api.maths.Cruncher;

public class Checker {
    final ExplosionCustom boom;

    public Checker(ExplosionCustom boom) {
        this.boom = boom;
    }

    protected ExplosionCustom.BlastResult getBlocksToRemove() {
        boolean oldBoom = true;
        return this.getBlocksToRemove2();
    }

    private ExplosionCustom.BlastResult getBlocksToRemove2() {
        int ind = this.boom.currentIndex;
        double scaleFactor = 1500.0;
        int num = (int)Math.sqrt((double)this.boom.strength * 1500.0 / 0.5);
        int max = this.boom.radius * 2 + 1;
        num = Math.min(num, max);
        num = Math.min(num, 1000);
        int numCubed = num * num * num;
        double radSq = num * num / 4;
        int maxIndex = numCubed;
        int increment = 0;
        ArrayList ret = Lists.newArrayList();
        ArrayList entityAffected = Lists.newArrayList();
        boolean done = true;
        long start = System.currentTimeMillis();
        this.boom.currentIndex = ind;
        while (this.boom.currentIndex < maxIndex) {
            double rSq;
            ++increment;
            long time = System.currentTimeMillis();
            if (time - start > 10L) {
                done = false;
                break;
            }
            Cruncher.indexToVals(this.boom.currentIndex, this.boom.r);
            if (!(this.boom.r.y + this.boom.centre.y < 0.0 || this.boom.r.y + this.boom.centre.y > 255.0 || (rSq = this.boom.r.magSq()) > radSq)) {
                double rMag = Math.sqrt(rSq);
                this.boom.rAbs.set(this.boom.r).addTo(this.boom.centre);
                this.boom.rHat.set(this.boom.r).norm();
                int index = Cruncher.getVectorInt(this.boom.rHat.scalarMultBy((double)num / 2.0));
                this.boom.rHat.scalarMultBy(2.0 / (double)num);
                if (!this.boom.blockedSet.contains(index)) {
                    double str = (double)this.boom.strength * 1500.0 / rSq;
                    if (this.boom.rAbs.isAir((IBlockReader)this.boom.field_77287_j) && !this.boom.r.isEmpty()) {
                        List hits;
                        if (ExplosionCustom.AFFECTINAIR && (hits = this.boom.field_77287_j.func_72839_b(this.boom.field_77283_e, this.boom.rAbs.getAABB().func_72314_b(0.5, 0.5, 0.5))) != null) {
                            for (Entity e : hits) {
                                entityAffected.add(new ExplosionCustom.HitEntity(e, (float)str));
                            }
                        }
                    } else {
                        if (str <= (double)this.boom.minBlastDamage) {
                            System.out.println("Terminating at distance " + rMag);
                            done = true;
                            break;
                        }
                        if (!this.boom.canBreak(this.boom.rAbs)) {
                            this.boom.blockedSet.add(index);
                        } else {
                            float res = this.boom.rAbs.getExplosionResistance(this.boom, (IWorldReader)this.boom.field_77287_j);
                            if (res > 1.0f) {
                                res *= res;
                            }
                            int index2 = Cruncher.getVectorInt(this.boom.r);
                            this.boom.resists.put(index2, Float.valueOf(res));
                            this.boom.checked.set(index2);
                            if ((double)res > str) {
                                this.boom.blockedSet.add(index);
                            } else {
                                boolean stop = false;
                                rMag = this.boom.r.mag();
                                float dj = 1.0f;
                                float resist = 0.0f;
                                float j = 0.0f;
                                while ((double)j <= rMag) {
                                    this.boom.rTest.set(this.boom.rHat).scalarMultBy(j);
                                    if (!this.boom.rTest.sameBlock(this.boom.rTestPrev)) {
                                        this.boom.rTestAbs.set(this.boom.rTest).addTo(this.boom.centre);
                                        index2 = Cruncher.getVectorInt(this.boom.rTest);
                                        if (this.boom.checked.get(index2)) {
                                            res = this.boom.resists.get(index2).floatValue();
                                        } else {
                                            res = this.boom.rTestAbs.getExplosionResistance(this.boom, (IWorldReader)this.boom.field_77287_j);
                                            if (res > 1.0f) {
                                                res *= res;
                                            }
                                            this.boom.resists.put(index2, Float.valueOf(res));
                                            this.boom.checked.set(index2);
                                        }
                                        resist += res;
                                        if (!this.boom.canBreak(this.boom.rTestAbs)) {
                                            stop = true;
                                            this.boom.blockedSet.add(index);
                                            break;
                                        }
                                        double d1 = this.boom.rTest.magSq();
                                        double d = d1;
                                        str = (double)this.boom.strength * 1500.0 / d;
                                        if ((double)resist > str) {
                                            stop = true;
                                            this.boom.blockedSet.add(index);
                                            break;
                                        }
                                    }
                                    this.boom.rTestPrev.set(this.boom.rTest);
                                    j += 1.0f;
                                }
                                if (!stop) {
                                    this.boom.rAbs.set(this.boom.r).addTo(this.boom.centre);
                                    IChunk chunk = this.boom.field_77287_j.func_217349_x(this.boom.rAbs.getPos());
                                    if (chunk == null) {
                                        System.out.println("No chunk at " + this.boom.rAbs);
                                        Thread.dumpStack();
                                    }
                                    if (!this.boom.affected.contains(chunk)) {
                                        this.boom.affected.add(chunk);
                                    }
                                    this.boom.addChunkPosition(this.boom.rAbs);
                                    List hits = this.boom.field_77287_j.func_72839_b(this.boom.field_77283_e, this.boom.rAbs.getAABB().func_72314_b(0.5, 0.5, 0.5));
                                    if (hits != null) {
                                        for (Entity e : hits) {
                                            entityAffected.add(new ExplosionCustom.HitEntity(e, (float)str));
                                        }
                                    }
                                    ret.add(new BlockPos((Vec3i)this.boom.rAbs.getPos()));
                                }
                            }
                        }
                    }
                }
            }
            ++this.boom.currentIndex;
        }
        this.boom.nextIndex = this.boom.currentIndex + increment;
        return new ExplosionCustom.BlastResult(ret, entityAffected, done);
    }
}

