/*
 * Decompiled with CFR 0.152.
 */
package thut.api.boom;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.boom.Checker;
import thut.api.maths.Vector3;
import thut.core.common.ThutCore;

public class ExplosionCustom
extends Explosion {
    public static int MAX_RADIUS = 127;
    public static Integer[] MAXPERTICK = new Integer[]{10000, 50000};
    public static float MINBLASTDAMAGE = 0.1f;
    public static boolean AFFECTINAIR = true;
    public static Block melt;
    public static Block solidmelt;
    public static Block dust;
    public IEntityHitter hitter = (e, power, boom) -> {
        EntitySize size = e.func_213305_a(e.func_213283_Z());
        float area = size.field_220315_a * size.field_220316_b;
        float damage = area * power;
        e.func_70097_a(DamageSource.func_94539_a((Explosion)boom), damage);
    };
    int currentIndex = 0;
    int nextIndex = 0;
    float minBlastDamage;
    int radius = MAX_RADIUS;
    public Integer[] maxPerTick;
    World field_77287_j;
    Vector3 centre;
    float strength;
    public boolean meteor = false;
    public PlayerEntity owner = null;
    List<Entity> targets = new ArrayList<Entity>();
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    Entity field_77283_e;
    public Set<BlockPos> field_77281_g = new HashSet<BlockPos>();
    Map<LivingEntity, Float> damages = new HashMap<LivingEntity, Float>();
    List<IChunk> affected = new ArrayList<IChunk>();
    HashMap<Integer, Float> resists = new HashMap(100000, 1.0f);
    HashSet<Integer> blockedSet = new HashSet(100000, 1.0f);
    Int2ObjectOpenHashMap<Float> thisShell = new Int2ObjectOpenHashMap();
    BitSet checked = new BitSet();
    Vector3 r = Vector3.getNewVector();
    Vector3 rAbs = Vector3.getNewVector();
    Vector3 rHat = Vector3.getNewVector();
    Vector3 rTest = Vector3.getNewVector();
    Vector3 rTestPrev = Vector3.getNewVector();
    Vector3 rTestAbs = Vector3.getNewVector();

    public ExplosionCustom(World world, Entity par2Entity, double x, double y, double z, float power) {
        this(world, par2Entity, Vector3.getNewVector().set(x, y, z), power);
    }

    public ExplosionCustom(World world, Entity par2Entity, Vector3 center, float power2) {
        super(world, par2Entity, center.x, center.y, center.z, power2, false, Explosion.Mode.DESTROY);
        this.field_77287_j = world;
        this.field_77283_e = par2Entity;
        this.strength = power2;
        this.explosionX = center.x;
        this.explosionY = center.y;
        this.explosionZ = center.z;
        this.centre = center.copy();
        this.minBlastDamage = MINBLASTDAMAGE;
        this.maxPerTick = (Integer[])MAXPERTICK.clone();
    }

    public void addChunkPosition(Vector3 v) {
        this.field_77281_g.add(new BlockPos(v.intX(), v.intY(), v.intZ()));
    }

    private void applyBlockEffects(List<BlockPos> toRemove) {
        this.func_180343_e().clear();
        for (BlockPos pos : toRemove) {
            this.func_180343_e().add(pos.func_185334_h());
            BlockState state = this.field_77287_j.func_180495_p(pos);
            this.doMeteorStuff(state, pos);
        }
    }

    private void applyEntityEffects(List<HitEntity> affected) {
        this.targets.clear();
        for (HitEntity e : affected) {
            Entity hit = e.entity;
            float power = e.blastStrength;
            if (!(power > 0.0f)) continue;
            this.hitter.hitEntity(hit, power, this);
            this.targets.add(hit);
        }
    }

    public boolean canBreak(Vector3 location) {
        boolean ret = true;
        if (this.owner != null) {
            try {
                BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(this.field_77287_j, location.getPos(), location.getBlockState((IBlockReader)this.field_77287_j), this.owner);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (evt.isCanceled()) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void doExplosion() {
        this.field_77287_j.func_184148_a((PlayerEntity)null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.field_77287_j.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.nextIndex = this.currentIndex + MAXPERTICK[0];
    }

    public void func_77278_a() {
        this.field_77281_g.clear();
        ThutCore.LOGGER.error("This should not be run anymore", (Throwable)new Exception());
    }

    public void func_77279_a(boolean par1) {
        ThutCore.LOGGER.error("This should not be run anymore", (Throwable)new Exception());
    }

    public void doKineticImpactor(World world, Vector3 velocity, Vector3 hitLocation, Vector3 acceleration, float density, float energy) {
        if (density < 0.0f || energy <= 0.0f) {
            return;
        }
        int max = 63;
        this.field_77281_g.clear();
        if (acceleration == null) {
            acceleration = Vector3.empty;
        }
        float factor = 1.0f;
        int n = 0;
        ArrayList<Vector3> locations = new ArrayList<Vector3>();
        ArrayList<Float> blasts = new ArrayList<Float>();
        float resist = hitLocation.getExplosionResistance(this, (IWorldReader)world);
        float blast = Math.min(energy * (resist / density), energy);
        if (resist > density) {
            hitLocation = hitLocation.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(world, this.field_77283_e, hitLocation, blast * 1.0f);
            boo.doExplosion();
            return;
        }
        Vector3 absorbedLoc = Vector3.getNewVector();
        float remainingEnergy = 0.0f;
        density -= resist;
        while (energy > 0.0f && density > 0.0f) {
            locations.add(hitLocation.subtract(velocity.normalize()));
            blasts.add(Float.valueOf(blast));
            hitLocation = hitLocation.add(velocity.normalize());
            velocity.add(acceleration);
            resist = Math.max(hitLocation.getExplosionResistance(this, (IWorldReader)world), 0.0f);
            blast = Math.min(energy * (resist / density), energy);
            if (resist > density) {
                absorbedLoc.set(hitLocation);
                remainingEnergy = energy;
                break;
            }
            energy -= energy * (resist / density);
            density = (float)((double)density - ((double)resist + 0.1));
        }
        if ((n = locations.size()) != 0) {
            for (int i = 0; i < n; ++i) {
                Vector3 source = (Vector3)locations.get(i);
                float strength = Math.min(((Float)blasts.get(i)).floatValue(), 256.0f);
                if (!world.isAreaLoaded(source.getPos(), 63) || strength == 0.0f) continue;
                ExplosionCustom boo = new ExplosionCustom(world, this.field_77283_e, source, strength * 1.0f);
                boo.doExplosion();
            }
        }
        if (remainingEnergy > 10.0f) {
            absorbedLoc = absorbedLoc.subtract(velocity.normalize());
            ExplosionCustom boo = new ExplosionCustom(world, this.field_77283_e, absorbedLoc, remainingEnergy * 1.0f);
            boo.doExplosion();
        }
    }

    public void doMeteorStuff(BlockState destroyed, BlockPos pos) {
        if (!destroyed.func_185904_a().func_76220_a() && !destroyed.func_185904_a().func_76224_d()) {
            return;
        }
        if (!this.meteor) {
            this.field_77287_j.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return;
        }
        this.field_77287_j.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    @SubscribeEvent
    void doRemoveBlocks(TickEvent.WorldTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START || evt.world != this.field_77287_j) {
            return;
        }
        BlastResult result = new Checker(this).getBlocksToRemove();
        this.applyBlockEffects(result.results);
        this.applyEntityEffects(result.hit);
        ExplosionEvent.Detonate evt2 = new ExplosionEvent.Detonate(this.field_77287_j, (Explosion)this, this.targets);
        MinecraftForge.EVENT_BUS.post((Event)evt2);
        if (result.done) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public ExplosionCustom setMaxRadius(int radius) {
        this.radius = radius;
        return this;
    }

    public ExplosionCustom setMeteor(boolean meteor) {
        this.meteor = meteor;
        return this;
    }

    @SubscribeEvent
    public void WorldUnloadEvent(WorldEvent.Unload evt) {
        if (evt.getWorld() == this.field_77287_j) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public static interface IEntityHitter {
        public void hitEntity(Entity var1, float var2, Explosion var3);
    }

    static class HitEntity {
        final Entity entity;
        final float blastStrength;

        public HitEntity(Entity entity, float blastStrength) {
            this.entity = entity;
            this.blastStrength = blastStrength;
        }
    }

    static class BlastResult {
        final List<BlockPos> results;
        final List<HitEntity> hit;
        final boolean done;

        public BlastResult(List<BlockPos> results, List<HitEntity> hit, boolean done) {
            this.results = results;
            this.hit = hit;
            this.done = done;
        }
    }
}

