/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.ai;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import org.apache.logging.log4j.Level;
import thut.api.entity.ai.IAIRunnable;
import thut.core.common.ThutCore;

public class GoalsWrapper
extends Goal {
    public final List<IAIRunnable> wrapped;
    private final Entity mob;
    private int lastTick = -1;

    public GoalsWrapper(Entity mob, IAIRunnable ... wrap) {
        this.wrapped = Lists.newArrayList((Object[])wrap);
        this.wrapped.sort((a, b) -> a.getPriority() - b.getPriority());
        this.mob = mob;
    }

    private boolean canRun(IAIRunnable task) {
        int prior = task.getPriority();
        int mutex = task.getMutex();
        for (int i = 0; i < this.wrapped.size(); ++i) {
            IAIRunnable ai = this.wrapped.get(i);
            if (ai.getPriority() >= prior || (mutex & ai.getMutex()) == 0 || !ai.shouldRun()) continue;
            return false;
        }
        return task.shouldRun();
    }

    public EnumSet<Goal.Flag> func_220686_i() {
        return super.func_220686_i();
    }

    public boolean func_220685_C_() {
        return false;
    }

    public void func_75251_c() {
    }

    public void func_220684_a(EnumSet<Goal.Flag> p_220684_1_) {
        super.func_220684_a(p_220684_1_);
    }

    public boolean func_75253_b() {
        return true;
    }

    public boolean func_75250_a() {
        return true;
    }

    public void func_75249_e() {
    }

    public void func_75246_d() {
        if (this.lastTick == this.mob.field_70173_aa) {
            return;
        }
        this.lastTick = this.mob.field_70173_aa;
        for (IAIRunnable ai : this.wrapped) {
            try {
                if (this.canRun(ai)) {
                    ai.run();
                    ai.tick();
                    ai.finish();
                    continue;
                }
                ai.reset();
            }
            catch (Exception e) {
                ThutCore.LOGGER.log(Level.FATAL, "error checking task " + ai, (Throwable)e);
            }
        }
    }
}

