/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.api.entity.blockentity.world.WorldEntity;
import thut.core.common.ThutCore;
import thut.core.common.network.EntityUpdate;

public abstract class BlockEntityBase
extends Entity
implements IEntityAdditionalSpawnData,
IBlockEntity {
    public static final IDataSerializer<Vec3d> VEC3DSER = new VecSer();
    static final DataParameter<Vec3d> velocity = EntityDataManager.func_187226_a(BlockEntityBase.class, VEC3DSER);
    static final DataParameter<Vec3d> position = EntityDataManager.func_187226_a(BlockEntityBase.class, VEC3DSER);
    public static int ACCELERATIONTICKS = 20;
    public BlockPos boundMin = BlockPos.field_177992_a;
    public BlockPos boundMax = BlockPos.field_177992_a;
    private IBlockEntityWorld fake_world;
    private boolean shouldRevert = true;
    public double speedUp = 0.5;
    public double speedDown = -0.5;
    public double speedHoriz = 0.5;
    public double acceleration = 0.05;
    public boolean toMoveY = false;
    public boolean toMoveX = false;
    public boolean toMoveZ = false;
    public boolean hasPassenger = false;
    int n = 0;
    boolean first = true;
    Random r = new Random();
    public UUID owner;
    public List<AxisAlignedBB> blockBoxes = Lists.newArrayList();
    public BlockState[][][] blocks = null;
    public TileEntity[][][] tiles = null;
    BlockEntityUpdater collider;
    BlockEntityInteractHandler interacter;

    public BlockEntityBase(EntityType<? extends BlockEntityBase> type, World par1World) {
        super(type, par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
    }

    protected abstract void accelerate();

    public void func_70108_f(Entity entity) {
        if (this.collider == null) {
            this.collider = new BlockEntityUpdater(this);
            this.collider.onSetPosition();
        }
        try {
            this.collider.applyEntityCollision(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        if (this.interacter == null) {
            this.interacter = this.createInteractHandler();
        }
        try {
            return this.interacter.applyPlayerInteraction(player, vec, player.func_184586_b(hand), hand);
        }
        catch (Exception e) {
            ThutCore.LOGGER.error("Error handling interactions for " + this, (Throwable)e);
            return super.func_184199_a(player, vec, hand);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean isServerWorld() {
        return !this.field_70170_p.field_72995_K;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_184186_bw() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected abstract boolean checkAccelerationConditions();

    public void checkCollision() {
        int zMax;
        int xMax;
        int zMin;
        int xMin = this.boundMin.func_177958_n();
        List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t + (double)(xMin - 2), this.field_70163_u, this.field_70161_v + (double)((zMin = this.boundMin.func_177952_p()) - 2), this.field_70165_t + (double)(xMax = this.boundMax.func_177958_n()) + 2.0, this.field_70163_u + 64.0, this.field_70161_v + (double)(zMax = this.boundMax.func_177952_p()) + 2.0));
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1 && this.func_184182_bu() != null && !this.func_184182_bu().isEmpty()) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.func_70108_f(entity);
            }
        }
    }

    protected abstract BlockEntityInteractHandler createInteractHandler();

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected abstract void doMotion();

    public Iterable<ItemStack> func_184193_aE() {
        return Lists.newArrayList();
    }

    @Override
    public BlockState[][][] getBlocks() {
        return this.blocks;
    }

    public boolean getCanSpawnHere() {
        return false;
    }

    @Override
    public IBlockEntityWorld getFakeWorld() {
        if (this.fake_world == null) {
            this.fake_world = new WorldEntity(this.field_70170_p);
            this.fake_world.setBlockEntity(this);
        }
        return this.fake_world;
    }

    @Override
    public BlockEntityInteractHandler getInteractor() {
        if (this.interacter == null) {
            this.interacter = this.createInteractHandler();
        }
        return this.interacter;
    }

    @Override
    public BlockPos getMax() {
        return this.boundMax;
    }

    @Override
    public BlockPos getMin() {
        return this.boundMin;
    }

    public Vec3d func_213322_ci() {
        return (Vec3d)this.func_184212_Q().func_187225_a(velocity);
    }

    protected double getSpeed(double pos, double destPos, double speed, double speedPos, double speedNeg) {
        if (!this.func_130014_f_().isAreaLoaded(this.func_180425_c(), 8)) {
            return 0.0;
        }
        double ds = speed;
        double dp = destPos - pos;
        if (dp > 0.0) {
            boolean tooFast;
            boolean bl = tooFast = pos + ds * (double)(ACCELERATIONTICKS + 1) > destPos;
            if (!tooFast) {
                ds = Math.min(speedPos, ds + this.acceleration * speedPos);
            } else {
                while (ds >= 0.0 && tooFast) {
                    tooFast = pos + (ds -= this.acceleration * speedPos / 10.0) * (double)(ACCELERATIONTICKS + 1) > destPos;
                }
            }
            return ds;
        }
        if (dp < 0.0) {
            boolean tooFast;
            speedNeg = Math.abs(speedNeg);
            boolean bl = tooFast = pos + ds * (double)(ACCELERATIONTICKS + 1) < destPos;
            if (!tooFast) {
                ds = Math.max(-speedNeg, ds - this.acceleration * speedNeg);
            } else {
                while (ds <= 0.0 && tooFast) {
                    tooFast = pos + (ds += this.acceleration * speedNeg / 10.0) * (double)(ACCELERATIONTICKS + 1) < destPos;
                }
            }
            return ds;
        }
        return 0.0;
    }

    @Override
    public TileEntity[][][] getTiles() {
        return this.tiles;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    protected abstract void onGridAlign();

    protected abstract void preColliderTick();

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (this.interacter == null) {
            this.interacter = this.createInteractHandler();
        }
        return this.interacter.processInitialInteract(player, player.func_184586_b(hand), hand);
    }

    public void func_70037_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("bounds")) {
            CompoundNBT bounds = nbt.func_74775_l("bounds");
            this.boundMin = new BlockPos(bounds.func_74769_h("minx"), bounds.func_74769_h("miny"), bounds.func_74769_h("minz"));
            this.boundMax = new BlockPos(bounds.func_74769_h("maxx"), bounds.func_74769_h("maxy"), bounds.func_74769_h("maxz"));
        }
        this.readBlocks(nbt);
    }

    public void readBlocks(CompoundNBT nbt) {
        if (nbt.func_74764_b("Blocks")) {
            CompoundNBT blockTag = nbt.func_74775_l("Blocks");
            int sizeX = blockTag.func_74762_e("BlocksLengthX");
            int sizeZ = blockTag.func_74762_e("BlocksLengthZ");
            int sizeY = blockTag.func_74762_e("BlocksLengthY");
            if (sizeX == 0 || sizeZ == 0) {
                sizeX = sizeZ = nbt.func_74762_e("BlocksLength");
            }
            if (sizeY == 0) {
                sizeY = 1;
            }
            this.blocks = new BlockState[sizeX][sizeY][sizeZ];
            this.tiles = new TileEntity[sizeX][sizeY][sizeZ];
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        BlockState state;
                        String name = "B" + i + "," + k + "," + j;
                        if (!blockTag.func_74764_b(name)) continue;
                        this.blocks[i][k][j] = state = NBTUtil.func_190008_d((CompoundNBT)blockTag.func_74775_l(name));
                        if (!blockTag.func_74764_b("T" + i + "," + k + "," + j)) continue;
                        try {
                            CompoundNBT tag = blockTag.func_74775_l("T" + i + "," + k + "," + j);
                            this.tiles[i][k][j] = TileEntity.func_203403_c((CompoundNBT)tag);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            this.setBlocks(this.blocks);
            this.setTiles(this.tiles);
        }
    }

    public void readSpawnData(PacketBuffer data) {
        this.func_70037_a(data.func_150793_b());
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(velocity, (Object)new Vec3d(0.0, 0.0, 0.0));
        this.func_184212_Q().func_187214_a(position, (Object)new Vec3d(0.0, 0.0, 0.0));
    }

    public void func_70106_y() {
        if (!this.func_130014_f_().field_72995_K && this.func_70089_S() && this.shouldRevert) {
            IBlockEntity.BlockEntityFormer.RevertEntity(this);
        }
        super.func_70106_y();
    }

    public void remove(boolean keepData) {
        this.shouldRevert = !keepData;
        super.remove(keepData);
    }

    public void func_174829_m() {
        BlockPos min = this.getMin();
        BlockPos max = this.getMax();
        float xDiff = (float)(max.func_177958_n() - min.func_177958_n()) / 2.0f;
        float zDiff = (float)(max.func_177952_p() - min.func_177952_p()) / 2.0f;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = xDiff % 1.0f != 0.0f ? axisalignedbb.field_72340_a + (double)xDiff : (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = axisalignedbb.field_72338_b;
        this.field_70161_v = zDiff % 1.0f != 0.0f ? axisalignedbb.field_72339_c + (double)zDiff : (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
    }

    @Override
    public void setBlocks(BlockState[][][] blocks) {
        this.blocks = blocks;
    }

    @Override
    public void setFakeWorld(IBlockEntityWorld world) {
        this.fake_world = world;
    }

    @Override
    public void setMax(BlockPos pos) {
        this.boundMax = pos;
    }

    @Override
    public void setMin(BlockPos pos) {
        this.boundMin = pos;
    }

    public void func_213317_d(Vec3d vec) {
        this.func_184212_Q().func_187227_b(velocity, (Object)vec);
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.func_184212_Q() != null) {
            if (this.isServerWorld()) {
                this.func_184212_Q().func_187227_b(position, (Object)new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
            Vec3d vec = (Vec3d)this.func_184212_Q().func_187225_a(position);
            this.field_70165_t = vec.field_72450_a;
            this.field_70163_u = vec.field_72448_b;
            this.field_70161_v = vec.field_72449_c;
        }
        if (this.collider != null) {
            this.collider.onSetPosition();
        }
    }

    @Override
    public void setTiles(TileEntity[][][] tiles) {
        this.tiles = tiles;
    }

    public void func_70071_h_() {
        if (this.getBlocks() == null && this.func_130014_f_().field_72995_K) {
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.isServerWorld() && this.field_70173_aa % 200 == 10) {
            EntityUpdate.sendEntityUpdate(this);
        }
        if (this.collider == null) {
            this.collider = new BlockEntityUpdater(this);
            this.collider.onSetPosition();
        }
        this.field_70177_z = 0.0f;
        this.field_70125_A = 0.0f;
        this.preColliderTick();
        this.collider.onUpdate();
        this.accelerate();
        int dy = (int)(this.func_213322_ci().field_72450_a * 16.0);
        int dx = (int)(this.func_213322_ci().field_72448_b * 16.0);
        int dz = (int)(this.func_213322_ci().field_72449_c * 16.0);
        if (this.toMoveY || this.toMoveX || this.toMoveZ) {
            this.doMotion();
        } else if (dx == dy && dy == dz && dz == 0 && !this.field_70170_p.field_72995_K) {
            boolean update;
            BlockPos pos = this.func_180425_c();
            boolean bl = update = this.field_70165_t != (double)pos.func_177958_n() + 0.5 || this.field_70163_u != (double)Math.round(this.field_70163_u) || this.field_70161_v != (double)pos.func_177952_p() + 0.5;
            if (update) {
                this.onGridAlign();
            }
        }
        this.checkCollision();
    }

    public void func_213281_b(CompoundNBT nbt) {
        CompoundNBT vector = new CompoundNBT();
        vector.func_74780_a("minx", (double)this.boundMin.func_177958_n());
        vector.func_74780_a("miny", (double)this.boundMin.func_177956_o());
        vector.func_74780_a("minz", (double)this.boundMin.func_177952_p());
        vector.func_74780_a("maxx", (double)this.boundMax.func_177958_n());
        vector.func_74780_a("maxy", (double)this.boundMax.func_177956_o());
        vector.func_74780_a("maxz", (double)this.boundMax.func_177952_p());
        nbt.func_218657_a("bounds", (INBT)vector);
        try {
            this.writeBlocks(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeBlocks(CompoundNBT nbt) {
        if (this.blocks != null) {
            CompoundNBT blocksTag = new CompoundNBT();
            blocksTag.func_74768_a("BlocksLengthX", this.blocks.length);
            blocksTag.func_74768_a("BlocksLengthY", this.blocks[0].length);
            blocksTag.func_74768_a("BlocksLengthZ", this.blocks[0][0].length);
            int sizeX = this.blocks.length;
            int sizeY = this.blocks[0].length;
            int sizeZ = this.blocks[0][0].length;
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        BlockState b = this.blocks[i][k][j];
                        if (b == null) continue;
                        blocksTag.func_218657_a("B" + i + "," + k + "," + j, (INBT)NBTUtil.func_190009_a((BlockState)b));
                        try {
                            if (this.tiles[i][k][j] == null) continue;
                            CompoundNBT tag = new CompoundNBT();
                            tag = this.tiles[i][k][j].func_189515_b(tag);
                            blocksTag.func_218657_a("T" + i + "," + k + "," + j, (INBT)tag);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            nbt.func_218657_a("Blocks", (INBT)blocksTag);
        }
    }

    public void writeSpawnData(PacketBuffer data) {
        CompoundNBT tag = new CompoundNBT();
        this.func_213281_b(tag);
        data.func_150786_a(tag);
    }

    private static class VecSer
    implements IDataSerializer<Vec3d> {
        private VecSer() {
        }

        public Vec3d copyValue(Vec3d value) {
            return new Vec3d(value.field_72450_a, value.field_72448_b, value.field_72449_c);
        }

        public DataParameter<Vec3d> func_187161_a(int id) {
            return new DataParameter(id, (IDataSerializer)this);
        }

        public Vec3d read(PacketBuffer buf) {
            return new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public void write(PacketBuffer buf, Vec3d value) {
            buf.writeDouble(value.field_72450_a);
            buf.writeDouble(value.field_72448_b);
            buf.writeDouble(value.field_72449_c);
        }
    }

    public static class BlockEntityType<T extends BlockEntityBase>
    extends EntityType<T> {
        public BlockEntityType(EntityType.IFactory<T> factory) {
            super(factory, EntityClassification.MISC, true, false, true, true, new EntitySize(1.0f, 1.0f, true), c -> true, c -> 64, c -> 1, null);
        }

        public T customClientSpawn(FMLPlayMessages.SpawnEntity packet, World world) {
            return (T)((BlockEntityBase)this.func_200721_a(world));
        }
    }
}

