/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import thut.api.entity.blockentity.IBlockEntity;

public abstract class BlockEntityInteractHandler {
    final IBlockEntity blockEntity;
    final Entity theEntity;

    public BlockEntityInteractHandler(IBlockEntity entity) {
        this.blockEntity = entity;
        this.theEntity = (Entity)entity;
    }

    public ActionResultType applyPlayerInteraction(PlayerEntity player, Vec3d vec, @Nullable ItemStack stack, Hand hand) {
        boolean activate;
        Vec3d playerPos;
        vec = vec.func_72441_c(vec.field_72450_a > 0.0 ? -0.01 : 0.01, vec.field_72448_b > 0.0 ? -0.01 : 0.01, vec.field_72449_c > 0.0 ? -0.01 : 0.01);
        Vec3d start = playerPos = player.func_174791_d().func_72441_c(0.0, player.func_70613_aW() ? (double)player.func_70047_e() : 0.0, 0.0);
        Vec3d end = playerPos.func_178787_e(player.func_70040_Z().func_186678_a(4.5));
        BlockRayTraceResult trace = null;
        RayTraceResult trace2 = IBlockEntity.BlockEntityFormer.rayTraceInternal(start, end, this.blockEntity);
        if (trace2 instanceof BlockRayTraceResult) {
            trace = (BlockRayTraceResult)trace2;
        }
        BlockPos pos = trace == null ? this.theEntity.func_180425_c() : trace.func_216350_a();
        BlockState state = this.blockEntity.getFakeWorld().getBlock(pos);
        World world = this.blockEntity.getFakeWorld() instanceof World ? (World)this.blockEntity.getFakeWorld() : this.theEntity.func_130014_f_();
        boolean bl = activate = state != null && state.func_215687_a(world, player, hand, trace);
        if (activate) {
            return ActionResultType.SUCCESS;
        }
        if (trace == null || trace.func_216346_c() == RayTraceResult.Type.MISS || state != null && !state.func_185904_a().func_76220_a()) {
            Vec3d playerLook = playerPos.func_178787_e(player.func_70040_Z().func_186678_a(4.0));
            RayTraceContext context = new RayTraceContext(playerPos, playerLook, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player);
            BlockRayTraceResult result = this.theEntity.func_130014_f_().func_217299_a(context);
            if (result instanceof BlockRayTraceResult) {
                ActionResultType itemUse;
                trace = result;
                pos = trace.func_216350_a();
                state = this.theEntity.func_130014_f_().func_180495_p(pos);
                ItemUseContext context2 = new ItemUseContext(player, hand, trace);
                if (player.func_70093_af() && !stack.func_190926_b() && (itemUse = ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)context2)) != ActionResultType.PASS) {
                    return itemUse;
                }
                activate = state.func_215687_a(world, player, hand, trace);
                if (activate) {
                    return ActionResultType.SUCCESS;
                }
                if (!player.func_70093_af() && !stack.func_190926_b() && (itemUse = ForgeHooks.onPlaceItemIntoWorld((ItemUseContext)context2)) != ActionResultType.PASS) {
                    return itemUse;
                }
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    public abstract ActionResultType interactInternal(PlayerEntity var1, BlockPos var2, @Nullable ItemStack var3, Hand var4);

    public boolean processInitialInteract(PlayerEntity player, @Nullable ItemStack stack, Hand hand) {
        return false;
    }
}

