/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import thut.api.TickHandler;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.world.IBlockEntityWorld;
import thut.api.maths.Matrix3;
import thut.api.maths.vecmath.Vector3f;

public class BlockEntityUpdater {
    public static boolean autoBlacklist = false;
    final IBlockEntity blockEntity;
    final Entity theEntity;
    List<AxisAlignedBB> blockBoxes = Lists.newArrayList();
    Set<TileEntity> erroredSet = Sets.newHashSet();

    public static boolean isWhitelisted(TileEntity tile) {
        ResourceLocation id = TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C());
        return id == null ? true : !IBlockEntity.TEBLACKLIST.contains(id.toString());
    }

    public BlockEntityUpdater(IBlockEntity rocket) {
        this.blockEntity = rocket;
        this.theEntity = (Entity)rocket;
    }

    public void applyEntityCollision(Entity entity) {
        double dy;
        double dz;
        double dx;
        if ((this.theEntity.field_70177_z + 360.0f) % 90.0f > 5.0f || this.theEntity.func_184196_w(entity)) {
            return;
        }
        this.blockBoxes.clear();
        int sizeX = this.blockEntity.getBlocks().length;
        int sizeY = this.blockEntity.getBlocks()[0].length;
        int sizeZ = this.blockEntity.getBlocks()[0][0].length;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xMin = this.blockEntity.getMin().func_177958_n();
        int yMin = this.blockEntity.getMin().func_177956_o();
        int zMin = this.blockEntity.getMin().func_177952_p();
        BlockPos origin = this.theEntity.func_180425_c();
        double minX = entity.func_174813_aQ().field_72340_a;
        double minY = entity.func_174813_aQ().field_72338_b;
        double minZ = entity.func_174813_aQ().field_72339_c;
        double maxX = entity.func_174813_aQ().field_72336_d;
        double maxY = entity.func_174813_aQ().field_72337_e;
        double maxZ = entity.func_174813_aQ().field_72334_f;
        Vec3d motion_a = this.theEntity.func_213322_ci();
        Vec3d motion_b = entity.func_213322_ci();
        Vector3f diffs = new Vector3f((float)(motion_a.field_72450_a - motion_b.field_72450_a), (float)(motion_a.field_72448_b - motion_b.field_72448_b), (float)(motion_a.field_72449_c - motion_b.field_72449_c));
        IBlockEntityWorld fakeworld = this.blockEntity.getFakeWorld();
        AxisAlignedBB boundingBox = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        AxisAlignedBB testBox = boundingBox.func_72321_a((double)(-diffs.x), (double)(-diffs.y), (double)(-diffs.z));
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    pos.func_181079_c(i + xMin + origin.func_177958_n(), j + yMin + origin.func_177956_o(), k + zMin + origin.func_177952_p());
                    BlockState state = fakeworld.func_180495_p((BlockPos)pos);
                    state = state.getExtendedState((IBlockReader)fakeworld, (BlockPos)pos);
                    VoxelShape shape = state.func_196952_d((IBlockReader)fakeworld, (BlockPos)pos);
                    List toAdd = shape.func_197756_d();
                    for (AxisAlignedBB blockBox : toAdd) {
                        if (blockBox == null) continue;
                        float dx2 = (float)(this.theEntity.field_70165_t - (double)origin.func_177958_n()) - 0.5f;
                        float dy2 = (float)(this.theEntity.field_70163_u - (double)origin.func_177956_o());
                        float dz2 = (float)(this.theEntity.field_70161_v - (double)origin.func_177952_p()) - 0.5f;
                        AxisAlignedBB box = blockBox.func_72317_d((double)(dx2 + (float)pos.func_177958_n()), (double)(dy2 + (float)pos.func_177956_o()), (double)(dz2 + (float)pos.func_177952_p()));
                        if (!box.func_72326_a(testBox)) continue;
                        this.blockBoxes.add(box);
                    }
                }
            }
        }
        if (this.blockBoxes.isEmpty()) {
            return;
        }
        pos.func_189533_g((Vec3i)this.theEntity.func_180425_c());
        Vector3f temp1 = new Vector3f();
        boolean merge = true;
        Matrix3.mergeAABBs(this.blockBoxes, 0.0, 0.0, 0.0);
        double lastTickMinY = minY + (double)diffs.y;
        double nextTickMinY = minY - (double)diffs.y;
        double lastTickMaxY = maxY + (double)diffs.y;
        double nextTickMaxY = maxY - (double)diffs.y;
        double lastTickMinX = minX + (double)diffs.x;
        double nextTickMinX = minX - (double)diffs.x;
        double lastTickMaxX = maxX + (double)diffs.x;
        double nextTickMaxX = maxX - (double)diffs.x;
        double lastTickMinZ = minZ + (double)diffs.z;
        double nextTickMinZ = minZ - (double)diffs.z;
        double lastTickMaxZ = maxZ + (double)diffs.z;
        double nextTickMaxZ = maxZ - (double)diffs.z;
        boolean colX = false;
        boolean colY = false;
        boolean colZ = false;
        float stepY = 0.0f;
        for (AxisAlignedBB aabb : this.blockBoxes) {
            float boxTopDist;
            double r;
            dx = 10000.0;
            dz = 10000.0;
            dy = 10000.0;
            boolean fromAbove = lastTickMinY >= aabb.field_72337_e && nextTickMinY <= aabb.field_72337_e;
            boolean fromBelow = nextTickMaxY >= aabb.field_72338_b && lastTickMaxY <= aabb.field_72338_b;
            boolean yPos = minY <= aabb.field_72337_e && minY >= aabb.field_72338_b;
            boolean yNeg = maxY <= aabb.field_72337_e && maxY >= aabb.field_72338_b;
            boolean fromXPos = lastTickMinX >= aabb.field_72336_d && nextTickMinX <= aabb.field_72336_d;
            boolean fromXNeg = nextTickMaxX >= aabb.field_72340_a && lastTickMaxX <= aabb.field_72340_a;
            boolean xPos = minX <= aabb.field_72336_d && minX >= aabb.field_72340_a;
            boolean xNeg = maxX <= aabb.field_72336_d && maxX >= aabb.field_72340_a;
            boolean fromZPos = lastTickMinZ >= aabb.field_72334_f && nextTickMinZ <= aabb.field_72334_f;
            boolean fromZNeg = nextTickMaxZ >= aabb.field_72339_c && lastTickMaxZ <= aabb.field_72339_c;
            boolean zPos = minZ <= aabb.field_72334_f && minZ >= aabb.field_72339_c;
            boolean zNeg = maxZ <= aabb.field_72334_f && maxZ >= aabb.field_72339_c;
            boolean collidesXPos = xPos && zPos && zNeg;
            boolean collidesXNeg = xNeg && zPos && zNeg;
            boolean collidesZPos = zPos && xPos && xNeg;
            boolean collidesZNeg = zNeg && xPos && xNeg;
            boolean collidesYNeg = yNeg && (xPos || xNeg || zPos || zNeg);
            boolean collidesYPos = yPos && (xPos || xNeg || zPos || zNeg);
            boolean collided = false;
            if (!collided && fromAbove) {
                temp1.y = (float)Math.max(aabb.field_72337_e - (double)diffs.y - nextTickMinY, (double)temp1.y);
                collided = true;
                colY = true;
            }
            if (!collided && fromBelow) {
                temp1.y = (float)Math.min(aabb.field_72338_b - (double)diffs.y - nextTickMaxY, (double)temp1.y);
                collided = true;
                colY = true;
            }
            if (!collided && (fromXPos || collidesXPos)) {
                r = Math.max(aabb.field_72336_d - boundingBox.field_72340_a, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
                colX = true;
            }
            if (!collided && (fromXNeg || collidesXNeg)) {
                r = Math.min(aabb.field_72340_a - boundingBox.field_72336_d, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
                colX = true;
            }
            if (!collided && (fromZPos || collidesZPos)) {
                r = Math.max(aabb.field_72334_f - boundingBox.field_72339_c, (double)temp1.z);
                dz = Math.min(dz, r);
                collided = true;
                colZ = true;
            }
            if (!collided && (fromZNeg || collidesZNeg)) {
                r = Math.min(aabb.field_72339_c - boundingBox.field_72334_f, (double)temp1.z);
                dz = Math.min(dz, r);
                collided = true;
                colZ = true;
            }
            if (!collided && xPos && zPos) {
                r = Math.max(aabb.field_72334_f - boundingBox.field_72339_c, (double)temp1.z);
                dz = Math.min(dz, r);
                r = Math.max(aabb.field_72336_d - boundingBox.field_72340_a, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
                colZ = true;
                colX = true;
            }
            if (!collided && xPos && zNeg) {
                r = Math.min(aabb.field_72339_c - boundingBox.field_72334_f, (double)temp1.z);
                dz = Math.min(dz, r);
                r = Math.max(aabb.field_72336_d - boundingBox.field_72340_a, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
                colZ = true;
                colX = true;
            }
            if (!collided && xNeg && zNeg) {
                r = Math.min(aabb.field_72339_c - boundingBox.field_72334_f, (double)temp1.z);
                dz = Math.min(dz, r);
                r = Math.min(aabb.field_72340_a - boundingBox.field_72336_d, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
                colZ = true;
                colX = true;
            }
            if (!collided && xNeg && zPos) {
                r = Math.max(aabb.field_72334_f - boundingBox.field_72339_c, (double)temp1.z);
                dz = Math.min(dz, r);
                r = Math.min(aabb.field_72340_a - boundingBox.field_72336_d, (double)temp1.x);
                dx = Math.min(dx, r);
                collided = true;
                colZ = true;
                colX = true;
            }
            if ((colX || colZ) && motion_a.field_72448_b == 0.0 && (boxTopDist = (float)Math.max(aabb.field_72337_e - (double)diffs.y - nextTickMinY, (double)temp1.y)) <= entity.field_70138_W) {
                collidesYPos = true;
                stepY = boxTopDist;
            }
            if (collidesYNeg) {
                r = (float)Math.min(aabb.field_72338_b - (double)diffs.y - nextTickMaxY, (double)temp1.y);
                dy = Math.min(r, dy);
                colY = true;
            } else if (collidesYPos) {
                r = (float)Math.max(aabb.field_72337_e - (double)diffs.y - nextTickMinY, (double)temp1.y);
                dy = Math.min(r, dy);
                colY = true;
            }
            double dy1 = Math.abs(dy);
            double dz1 = Math.abs(dz);
            double dx1 = Math.abs(dx);
            if (dy1 < dx1 && dy1 < dz1) {
                temp1.y = (float)dy;
                continue;
            }
            if (dx1 < dy1 && dx1 < dz1) {
                temp1.x = (float)dx;
                continue;
            }
            if (!(dz < 1000.0)) continue;
            temp1.z = (float)dz;
        }
        temp1.y += stepY;
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (player.func_130014_f_().field_72995_K && (Minecraft.func_71410_x().field_71474_y.field_74336_f || TickHandler.playerTickTracker.containsKey(player.func_110124_au()))) {
                TickHandler.playerTickTracker.put(player.func_110124_au(), (int)(System.currentTimeMillis() % 2000L));
                Minecraft.func_71410_x().field_71474_y.field_74336_f = false;
            }
            if (player.func_130014_f_().field_72995_K) {
                player.getPersistentData().func_74768_a("lastStandTick", player.field_70173_aa);
            }
            if (!player.field_71075_bZ.field_75100_b) {
                entity.field_70122_E = true;
                entity.func_180430_e(entity.field_70143_R, 0.0f);
                entity.field_70143_R = 0.0f;
            }
            if (!player.field_71075_bZ.field_75098_d && !player.func_130014_f_().field_72995_K) {
                ServerPlayerEntity serverplayer = (ServerPlayerEntity)player;
                serverplayer.field_71135_a.field_147365_f = 0;
            }
        }
        if (colX || colY || colZ) {
            if (temp1.y >= 0.0f) {
                entity.field_70122_E = true;
                entity.func_180430_e(entity.field_70143_R, 0.0f);
                entity.field_70143_R = 0.0f;
            }
            if ((double)temp1.length() > 0.001) {
                Vec3d motion = new Vec3d((double)temp1.x, (double)temp1.y, (double)temp1.z);
                entity.func_213315_a(MoverType.SELF, motion);
            }
            dx = motion_b.field_72450_a;
            dy = motion_b.field_72448_b;
            dz = motion_b.field_72449_c;
            if (colX) {
                dx = motion_a.field_72450_a;
            }
            if (colY) {
                dy = motion_a.field_72448_b;
            }
            if (colZ) {
                dz = motion_a.field_72449_c;
            }
            entity.func_213293_j(dx *= 0.9, dy, dz *= 0.9);
        }
    }

    public void onSetPosition() {
        double xMin = this.theEntity.field_70165_t + (double)this.blockEntity.getMin().func_177958_n() - 0.5;
        double yMin = this.theEntity.field_70163_u + (double)this.blockEntity.getMin().func_177956_o();
        double zMin = this.theEntity.field_70161_v + (double)this.blockEntity.getMin().func_177952_p() - 0.5;
        double xMax = this.theEntity.field_70165_t + (double)this.blockEntity.getMax().func_177958_n() + 0.5;
        double yMax = this.theEntity.field_70163_u + (double)this.blockEntity.getMax().func_177956_o() + 1.0;
        double zMax = this.theEntity.field_70161_v + (double)this.blockEntity.getMax().func_177952_p() + 0.5;
        this.theEntity.func_174826_a(new AxisAlignedBB(xMin, yMin, zMin, xMax, yMax, zMax));
    }

    public void onUpdate() {
        if (this.blockEntity.getBlocks() == null) {
            return;
        }
        double wMax = this.theEntity.func_130014_f_().getMaxEntityRadius();
        double uMax = -1.0;
        if (wMax < (double)this.blockEntity.getBlocks().length) {
            uMax = this.blockEntity.getBlocks().length;
        }
        if (wMax < (double)this.blockEntity.getBlocks()[0].length) {
            uMax = this.blockEntity.getBlocks()[0].length;
        }
        if (wMax < (double)this.blockEntity.getBlocks()[0][0].length) {
            uMax = this.blockEntity.getBlocks()[0][0].length;
        }
        this.theEntity.func_130014_f_().increaseMaxEntityRadius(uMax);
        EntitySize size = this.theEntity.func_213305_a(this.theEntity.func_213283_Z());
        size = EntitySize.func_220311_c((float)(1 + this.blockEntity.getMax().func_177958_n() - this.blockEntity.getMin().func_177958_n()), (float)this.blockEntity.getMax().func_177956_o());
        this.blockEntity.setSize(size);
        if (this.theEntity.func_213322_ci().field_72448_b == 0.0) {
            this.theEntity.func_70107_b(this.theEntity.field_70165_t, (double)Math.round(this.theEntity.field_70163_u), this.theEntity.field_70161_v);
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xMin = this.blockEntity.getMin().func_177958_n();
        int zMin = this.blockEntity.getMin().func_177952_p();
        int yMin = this.blockEntity.getMin().func_177956_o();
        int sizeX = this.blockEntity.getTiles().length;
        int sizeY = this.blockEntity.getTiles()[0].length;
        int sizeZ = this.blockEntity.getTiles()[0][0].length;
        World world = this.blockEntity.getFakeWorld() instanceof World ? (World)this.blockEntity.getFakeWorld() : this.theEntity.func_130014_f_();
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    pos.func_189532_c((double)(i + xMin) + this.theEntity.field_70165_t, (double)(j + yMin) + this.theEntity.field_70163_u, (double)(k + zMin) + this.theEntity.field_70161_v);
                    TileEntity tile = this.blockEntity.getTiles()[i][j][k];
                    if (tile != null) {
                        tile.func_174878_a(pos.func_185334_h());
                        tile.func_145834_a(world);
                    }
                    if (!(tile instanceof ITickable) || this.erroredSet.contains(tile) || !BlockEntityUpdater.isWhitelisted(tile)) continue;
                    try {
                        ((ITickable)tile).func_110550_d();
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        System.err.println("Error with Tile Entity " + tile);
                        this.erroredSet.add(tile);
                        if (!autoBlacklist || TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C()) == null) continue;
                        IBlockEntity.TEBLACKLIST.add(TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C()).toString());
                    }
                }
            }
        }
    }
}

