/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.lwjgl.opengl.GL11;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.IBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class RenderBlockEntity<T extends BlockEntityBase>
extends EntityRenderer<T> {
    private static IBakedModel crate_model;
    static final Tessellator t;
    float pitch = 0.0f;
    float yaw = 0.0f;
    long time = 0L;
    boolean up = true;
    BufferBuilder b = t.func_178180_c();
    ResourceLocation texture;

    public RenderBlockEntity(EntityRendererManager manager) {
        super(manager);
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (!(entity instanceof IBlockEntity)) {
            return;
        }
        try {
            T blockEntity = entity;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)(y + 0.5), (double)z);
            if (entity instanceof IMultiplePassengerEntity) {
                IMultiplePassengerEntity multi = (IMultiplePassengerEntity)entity;
                float yaw = -(multi.getPrevYaw() + (multi.getYaw() - multi.getPrevYaw()) * partialTicks);
                float pitch = -(multi.getPrevPitch() + (multi.getPitch() - multi.getPrevPitch()) * partialTicks);
                GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int xMin = MathHelper.func_76141_d((float)blockEntity.getMin().func_177958_n());
            int xMax = MathHelper.func_76141_d((float)blockEntity.getMax().func_177958_n());
            int zMin = MathHelper.func_76141_d((float)blockEntity.getMin().func_177952_p());
            int zMax = MathHelper.func_76141_d((float)blockEntity.getMax().func_177952_p());
            int yMin = MathHelper.func_76141_d((float)blockEntity.getMin().func_177956_o());
            int yMax = MathHelper.func_76141_d((float)blockEntity.getMax().func_177956_o());
            for (int i = xMin; i <= xMax; ++i) {
                for (int j = yMin; j <= yMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        pos.func_181079_c(i - xMin, j - yMin, k - zMin);
                        if (!blockEntity.shouldHide((BlockPos)pos)) {
                            this.drawBlockAt((BlockPos)pos, (IBlockEntity)blockEntity);
                            this.drawTileAt((BlockPos)pos, (IBlockEntity)blockEntity, partialTicks);
                            continue;
                        }
                        this.drawCrateAt(pos, (IBlockEntity)blockEntity);
                    }
                }
            }
            GL11.glPopMatrix();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawBlockAt(BlockPos pos, IBlockEntity entity) {
        if (entity.getBlocks() == null) {
            return;
        }
        BlockState BlockState2 = entity.getBlocks()[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()];
        BlockPos mobPos = entity.getMin();
        pos = pos.func_177971_a((Vec3i)mobPos);
        if (BlockState2 == null) {
            BlockState2 = Blocks.field_150350_a.func_176223_P();
        }
        if (BlockState2.func_185904_a() != Material.field_151579_a) {
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            BlockState actualstate = BlockState2.getExtendedState((IBlockReader)entity.getFakeWorld(), pos);
            if ((actualstate = actualstate.func_177230_c().getExtendedState(actualstate, (IBlockReader)entity.getFakeWorld(), pos)).func_185901_i() == BlockRenderType.MODEL) {
                GlStateManager.pushMatrix();
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.disableLighting();
                float f7 = 1.0f;
                GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                IBakedModel model = blockrendererdispatcher.func_184389_a(actualstate);
                this.renderBakedBlockModel(entity, model, actualstate, (IBlockReader)((Entity)entity).func_130014_f_(), pos);
                GlStateManager.enableLighting();
                GlStateManager.popMatrix();
            }
        }
    }

    private void drawCrateAt(BlockPos.MutableBlockPos pos, IBlockEntity blockEntity) {
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        RenderHelper.func_74518_a();
        boolean blend = GL11.glGetBoolean((int)3042);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.func_71379_u()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        float f7 = 1.0f;
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_110776_a(AtlasTexture.field_110575_b);
        this.getCrateModel();
        if (!blend) {
            GL11.glDisable((int)3042);
        }
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
    }

    private void drawTileAt(BlockPos pos, IBlockEntity entity, float partialTicks) {
        TileEntity tile = entity.getTiles()[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()];
        if (tile != null) {
            GL11.glPushMatrix();
            BlockPos origin = ((Entity)entity).func_180425_c();
            pos = origin.func_177973_b((Vec3i)pos);
            GlStateManager.translatef((float)-0.5f, (float)0.5f, (float)-0.5f);
            boolean fast = tile.hasFastRenderer();
            if (fast) {
                TileEntityRendererDispatcher.field_147556_a.preDrawBatch();
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, 0.0, 0.0, 0.0, partialTicks);
                TileEntityRendererDispatcher.field_147556_a.drawBatch();
            } else {
                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, 0.0, 0.0, 0.0, partialTicks);
            }
            GL11.glPopMatrix();
        }
    }

    private IBakedModel getCrateModel() {
        if (crate_model == null) {
            // empty if block
        }
        return crate_model;
    }

    public ResourceLocation getEntityTexture(T entity) {
        return AtlasTexture.field_110575_b;
    }

    private void renderBakedBlockModel(IBlockEntity entity, IBakedModel model, BlockState state, IBlockReader world, BlockPos pos) {
        GL11.glPushMatrix();
        GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        BlockPos origin = ((Entity)entity).func_180425_c();
        pos = origin.func_177973_b((Vec3i)pos);
        GlStateManager.translatef((float)(-pos.func_177958_n()), (float)(-pos.func_177956_o()), (float)(-pos.func_177952_p()));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.func_110776_a(AtlasTexture.field_110575_b);
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().renderModelSmooth((IEnviromentBlockReader)entity.getFakeWorld().getWorld(), model, state, origin, buffer, false, new Random(), 0L, (IModelData)EmptyModelData.INSTANCE);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    static {
        t = new Tessellator(0x200000);
    }
}

