/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.genetics;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import thut.api.entity.genetics.Gene;
import thut.api.entity.genetics.IMobGenetics;
import thut.core.common.ThutCore;

public class GeneRegistry {
    @CapabilityInject(value=IMobGenetics.class)
    public static final Capability<IMobGenetics> GENETICS_CAP = null;
    static Map<ResourceLocation, Class<? extends Gene>> geneMap = Maps.newHashMap();

    public static Class<? extends Gene> getClass(ResourceLocation location) {
        return geneMap.get(location);
    }

    public static Collection<Class<? extends Gene>> getGenes() {
        return geneMap.values();
    }

    public static Gene load(CompoundNBT tag) throws Exception {
        Gene ret = null;
        ResourceLocation resource = new ResourceLocation(tag.func_74779_i("K"));
        ret = geneMap.get(resource).newInstance();
        ret.load(tag);
        return ret;
    }

    public static void register(Class<? extends Gene> gene) {
        try {
            Gene temp = gene.newInstance();
            geneMap.put(temp.getKey(), gene);
        }
        catch (IllegalAccessException | InstantiationException e) {
            ThutCore.LOGGER.error("Error with registry of " + gene, (Throwable)e);
        }
    }

    public static CompoundNBT save(Gene gene) {
        CompoundNBT tag = gene.save();
        tag.func_74778_a("K", gene.getKey().toString());
        return tag;
    }
}

