/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thut.api.terrain.CapabilityTerrain;
import thut.api.terrain.TerrainSegment;

public interface ITerrainProvider {
    public static final Map<BlockPos, TerrainSegment> pendingCache = Maps.newHashMap();

    default public TerrainSegment getTerrain(IWorld world, BlockPos p) {
        ChunkPos temp = new ChunkPos(p);
        BlockPos pos = new BlockPos(temp.field_77276_a, p.func_177956_o() / 16, temp.field_77275_b);
        if (!(world instanceof ICapabilityProvider)) {
            if (pendingCache.containsKey(pos)) {
                return pendingCache.get(pos);
            }
            TerrainSegment segment = new TerrainSegment(pos);
            pendingCache.put(pos, segment);
            return segment;
        }
        CapabilityTerrain.ITerrainProvider provider = (CapabilityTerrain.ITerrainProvider)((ICapabilityProvider)world.func_217349_x(p)).getCapability(CapabilityTerrain.TERRAIN_CAP).orElse(null);
        if (pendingCache.containsKey(pos)) {
            TerrainSegment cached = pendingCache.remove(pos);
            provider.setTerrainSegment(cached, pos.func_177956_o());
        }
        return provider.getTerrainSegement(p);
    }
}

