/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.maths.Vector3;
import thut.api.terrain.CapabilityTerrain;
import thut.api.terrain.ITerrainProvider;
import thut.api.terrain.TerrainSegment;

public class TerrainManager {
    public static final ResourceLocation TERRAINCAP = new ResourceLocation("thutcore", "terrain");
    private static TerrainManager terrain;
    public ITerrainProvider provider = new ITerrainProvider(){};

    public static void clear() {
    }

    public static TerrainManager getInstance() {
        if (terrain == null) {
            terrain = new TerrainManager();
        }
        return terrain;
    }

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<Chunk> event) {
        if (event.getCapabilities().containsKey(TERRAINCAP)) {
            return;
        }
        Chunk chunk = (Chunk)event.getObject();
        CapabilityTerrain.DefaultProvider terrain = new CapabilityTerrain.DefaultProvider((IChunk)chunk);
        event.addCapability(TERRAINCAP, (ICapabilityProvider)terrain);
    }

    public TerrainSegment getTerrain(IWorld world, BlockPos p) {
        return this.provider.getTerrain(world, p);
    }

    public TerrainSegment getTerrain(IWorld world, double x, double y, double z) {
        BlockPos pos = new BlockPos(x, y, z);
        TerrainSegment ret = this.getTerrain(world, pos);
        if (world instanceof ServerWorld) {
            ret.initBiomes(world);
        }
        return ret;
    }

    public TerrainSegment getTerrainForEntity(Entity e) {
        if (e == null) {
            return null;
        }
        return this.getTerrain((IWorld)e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public TerrainSegment getTerrian(IWorld world, Vector3 v) {
        return this.getTerrain(world, v.x, v.y, v.z);
    }
}

