/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeDatabase;
import thut.api.terrain.BiomeType;
import thut.core.common.ThutCore;

public class TerrainSegment {
    public static final int GRIDSIZE = 4;
    public static ISubBiomeChecker defaultChecker = new DefaultChecker();
    public static List<ISubBiomeChecker> biomeCheckers = Lists.newArrayList();
    public static Set<Class<? extends ITerrainEffect>> terrainEffectClasses = Sets.newHashSet();
    public static boolean noLoad = false;
    public static Predicate<Integer> saveChecker = i -> i != -1 && i.intValue() != BiomeType.CAVE.getType() && i.intValue() != BiomeType.SKY.getType() && i.intValue() != BiomeType.NONE.getType();
    public Map<Integer, Integer> idReplacements;
    public final int chunkX;
    public final int chunkY;
    public final int chunkZ;
    public final BlockPos pos;
    public IChunk chunk;
    public boolean toSave = false;
    public boolean isSky = false;
    public boolean init = true;
    Vector3 temp = Vector3.getNewVector();
    Vector3 temp1 = Vector3.getNewVector();
    Vector3 mid = Vector3.getNewVector();
    int[] biomes = new int[64];
    HashMap<String, ITerrainEffect> effects = new HashMap();
    public final ITerrainEffect[] effectArr;

    public static int count(IWorld world, Block b, Vector3 v, int range) {
        Vector3 temp = Vector3.getNewVector();
        temp.set(v);
        int ret = 0;
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    boolean bool = true;
                    int i1 = MathHelper.func_76141_d((float)(v.intX() + i)) >> 4;
                    int k1 = MathHelper.func_76141_d((float)(v.intZ() + i)) >> 4;
                    boolean bl = bool = i1 == v.intX() >> 4 && k1 == v.intZ() >> 4;
                    if (!bool) continue;
                    temp.set(v).addTo(i, j, k);
                    BlockState state = world.func_180495_p(temp.getPos());
                    if (state.func_177230_c() != b && (b != null || state.func_177230_c() != null)) continue;
                    ++ret;
                }
            }
        }
        return ret;
    }

    public static boolean isInTerrainColumn(Vector3 t, Vector3 point) {
        boolean ret = true;
        int i = point.intX() >> 4;
        int k = point.intZ() >> 4;
        ret = i == t.intX() && k == t.intZ();
        return ret;
    }

    public static void readFromNBT(TerrainSegment t, CompoundNBT nbt) {
        if (noLoad) {
            return;
        }
        int[] biomes = nbt.func_74759_k("biomes");
        t.init = t.toSave = nbt.func_74767_n("toSave");
        boolean replacements = false;
        if (t.idReplacements != null) {
            for (int i = 0; i < biomes.length; ++i) {
                if (!t.idReplacements.containsKey(biomes[i])) continue;
                biomes[i] = t.idReplacements.get(biomes[i]);
                replacements = true;
            }
        }
        if (replacements) {
            System.out.println("Replacement subbiomes found for " + t.chunkX + " " + t.chunkY + " " + t.chunkZ);
        }
        t.setBiome(biomes);
    }

    public TerrainSegment(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public TerrainSegment(int x, int y, int z) {
        this.chunkX = x;
        this.chunkY = y;
        this.chunkZ = z;
        this.pos = new BlockPos(x, y, z);
        Arrays.fill(this.biomes, -1);
        this.mid.set(this.chunkX * 16 + 8, this.chunkY * 16 + 8, this.chunkZ * 16 + 8);
        for (Class<? extends ITerrainEffect> clas : terrainEffectClasses) {
            try {
                ITerrainEffect effect = clas.newInstance();
                this.addEffect(effect, effect.getIdenitifer());
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        ArrayList toSort = Lists.newArrayList(this.effects.values());
        toSort.sort((o1, o2) -> o1.getIdenitifer().compareTo(o2.getIdenitifer()));
        this.effectArr = toSort.toArray(new ITerrainEffect[0]);
    }

    private void addEffect(ITerrainEffect effect, String name) {
        effect.bindToTerrain(this.chunkX, this.chunkY, this.chunkZ);
        this.effects.put(name, effect);
    }

    public int adjustedCaveBiome(IWorld world, Vector3 v) {
        return this.getBiome(world, v, true);
    }

    public int adjustedNonCaveBiome(IWorld world, Vector3 v) {
        return this.getBiome(world, v, false);
    }

    void checkToSave() {
        for (int temp1 : this.biomes) {
            if (!saveChecker.test(temp1)) continue;
            this.toSave = true;
            return;
        }
        this.toSave = false;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof TerrainSegment) {
            ret = ((TerrainSegment)o).chunkX == this.chunkX && ((TerrainSegment)o).chunkY == this.chunkY && ((TerrainSegment)o).chunkZ == this.chunkZ;
        }
        return ret;
    }

    public double getAverageSlope(World world, Vector3 point, int range) {
        double slope = 0.0;
        double prevY = point.getMaxY((IWorld)world);
        double dy = 0.0;
        double dz = 0.0;
        this.temp1.set(this.temp);
        this.temp.set(point);
        int count = 0;
        for (int i = -range; i <= range; ++i) {
            dz = 0.0;
            for (int j = -range; j <= range; ++j) {
                if (TerrainSegment.isInTerrainColumn(point, this.temp.addTo(i, 0.0, j))) {
                    dy += Math.abs((double)point.getMaxY((IWorld)world, point.intX() + i, point.intZ() + j) - prevY);
                }
                dz += 1.0;
                ++count;
                this.temp.set(point);
            }
            slope += dy / dz;
        }
        this.temp.set(this.temp1);
        return slope / (double)count;
    }

    public int getBiome(int x, int y, int z) {
        int ret = 0;
        int relX = (x & 0xF) / 4;
        int relY = (y & 0xF) / 4;
        int relZ = (z & 0xF) / 4;
        if (relX < 4 && relY < 4 && relZ < 4) {
            ret = this.biomes[relX + 4 * relY + 16 * relZ];
        }
        if (saveChecker.test(ret)) {
            this.toSave = true;
        }
        return ret;
    }

    public int getBiome(Vector3 v) {
        return this.getBiome(v.intX(), v.intY(), v.intZ());
    }

    private int getBiome(IWorld world, Vector3 v, boolean caveAdjust) {
        if (this.chunk == null || this.chunk.func_76632_l().field_77276_a != this.chunkX || this.chunk.func_76632_l().field_77275_b != this.chunkZ) {
            this.chunk = world.func_212866_a_(this.chunkX, this.chunkZ);
        }
        if (this.chunk == null) {
            Thread.dumpStack();
            return -1;
        }
        if (!biomeCheckers.isEmpty()) {
            for (ISubBiomeChecker checker : biomeCheckers) {
                int biome = checker.getSubBiome(world, v, this, caveAdjust);
                if (biome == -1) continue;
                return biome;
            }
        }
        return defaultChecker.getSubBiome(world, v, this, caveAdjust);
    }

    public Vector3 getCentre() {
        return this.mid;
    }

    public BlockPos getChunkCoords() {
        return this.pos;
    }

    public Collection<ITerrainEffect> getEffects() {
        return this.effects.values();
    }

    public ITerrainEffect geTerrainEffect(String name) {
        return this.effects.get(name);
    }

    public int hashCode() {
        return this.chunkX + this.chunkZ << 8 << 8 + this.chunkY;
    }

    public void initBiomes(IWorld world) {
        if (this.init && world instanceof ServerWorld) {
            this.refresh(world);
            this.init = false;
        }
    }

    public boolean isInTerrainSegment(double x, double y, double z) {
        boolean ret = true;
        int i = MathHelper.func_76128_c((double)x) >> 4;
        int j = MathHelper.func_76128_c((double)y) >> 4;
        int k = MathHelper.func_76128_c((double)z) >> 4;
        ret = i == this.chunkX && k == this.chunkZ && j == this.chunkY;
        return ret;
    }

    public void refresh(IWorld world) {
        long time = System.nanoTime();
        if (this.chunk == null) {
            this.chunk = world.func_212866_a_(this.chunkX, this.chunkZ);
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    int index = i + 4 * j + 16 * k;
                    if (saveChecker.test(this.biomes[index]) && !noLoad) continue;
                    this.temp.set(this.chunkX * 16 + i * 16 / 4, this.chunkY * 16 + j * 16 / 4, this.chunkZ * 16 + k * 16 / 4);
                    int biome = this.adjustedCaveBiome(world, this.temp);
                    if (biome == -1) {
                        biome = this.adjustedNonCaveBiome(world, this.temp);
                    }
                    if (biome == -1) continue;
                    if (saveChecker.test(biome)) {
                        this.toSave = true;
                    }
                    this.biomes[index] = biome;
                }
            }
        }
        double dt = (double)(System.nanoTime() - time) / 1.0E10;
        if (dt > 0.001) {
            ThutCore.LOGGER.debug("subBiome refresh took " + dt);
        }
    }

    public void saveToNBT(CompoundNBT nbt) {
        if (!this.toSave) {
            return;
        }
        nbt.func_74783_a("biomes", this.biomes);
        nbt.func_74768_a("x", this.chunkX);
        nbt.func_74768_a("y", this.chunkY);
        nbt.func_74768_a("z", this.chunkZ);
        nbt.func_74757_a("toSave", this.toSave);
    }

    public void setBiome(BlockPos p, int type) {
        this.setBiome(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), type);
    }

    public void setBiome(int x, int y, int z, int biome) {
        int relX = (x & 0xF) / 4;
        int relY = (y & 0xF) / 4;
        int relZ = (z & 0xF) / 4;
        this.biomes[relX + 4 * relY + 16 * relZ] = biome;
        if (saveChecker.test(biome)) {
            this.toSave = true;
        }
    }

    public void setBiome(int[] biomes) {
        if (biomes.length == this.biomes.length) {
            this.biomes = biomes;
        } else {
            for (int i = 0; i < biomes.length; ++i) {
                if (i >= this.biomes.length) {
                    return;
                }
                this.biomes[i] = biomes[i];
            }
        }
    }

    public void setBiome(Vector3 v, BiomeType type) {
        this.setBiome(v, type.getType());
    }

    public void setBiome(Vector3 v, int i) {
        this.setBiome(v.intX(), v.intY(), v.intZ(), i);
    }

    public String toString() {
        String ret = "Terrian Segment " + this.chunkX + "," + this.chunkY + "," + this.chunkZ + " Centre:" + this.getCentre();
        String eol = System.getProperty("line.separator");
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                String line = "[";
                for (int k = 0; k < 4; ++k) {
                    line = line + this.biomes[i + 4 * j + 16 * k];
                    if (k == 3) continue;
                    line = line + ", ";
                }
                line = line + "]";
                ret = ret + eol + line;
            }
        }
        return ret;
    }

    public static interface ITerrainEffect {
        public void bindToTerrain(int var1, int var2, int var3);

        public void doEffect(LivingEntity var1, boolean var2);

        public String getIdenitifer();

        public void readFromNBT(CompoundNBT var1);

        public void writeToNBT(CompoundNBT var1);
    }

    public static interface ISubBiomeChecker {
        public int getSubBiome(IWorld var1, Vector3 var2, TerrainSegment var3, boolean var4);
    }

    public static class DefaultChecker
    implements ISubBiomeChecker {
        @Override
        public int getSubBiome(IWorld world, Vector3 v, TerrainSegment segment, boolean caveAdjusted) {
            if (caveAdjusted) {
                if (!world.func_201675_m().func_76569_d()) {
                    return -1;
                }
                boolean sky = false;
                Vector3 temp1 = Vector3.getNewVector();
                int x0 = segment.chunkX * 16;
                int y0 = segment.chunkY * 16;
                int z0 = segment.chunkZ * 16;
                int dx = (v.intX() - x0) / 4 * 4;
                int dy = (v.intY() - y0) / 4 * 4;
                int dz = (v.intZ() - z0) / 4 * 4;
                int x1 = x0 + dx;
                int y1 = y0 + dy;
                int z1 = z0 + dz;
                block0: for (int i = x1; i < x1 + 4; ++i) {
                    for (int j = y1; j < y1 + 4; ++j) {
                        for (int k = z1; k < z1 + 4; ++k) {
                            temp1.set(i, j, k);
                            if (segment.isInTerrainSegment(temp1.x, temp1.y, temp1.z)) {
                                double y = temp1.getMaxY(world);
                                boolean bl = sky = y <= temp1.y;
                            }
                            if (sky) break block0;
                        }
                    }
                }
                if (sky) {
                    return -1;
                }
                if (!sky && TerrainSegment.count(world, Blocks.field_150355_j, v, 1) > 2) {
                    return BiomeType.CAVE_WATER.getType();
                }
                if (!sky) {
                    return BiomeType.CAVE.getType();
                }
            } else {
                BlockPos pos;
                ServerWorld server;
                int water;
                boolean notLake;
                int biome = -1;
                Biome b = v.getBiome(world);
                boolean bl = notLake = BiomeDatabase.contains(b, BiomeDictionary.Type.OCEAN) || BiomeDatabase.contains(b, BiomeDictionary.Type.SWAMP) || BiomeDatabase.contains(b, BiomeDictionary.Type.RIVER) || BiomeDatabase.contains(b, BiomeDictionary.Type.WATER) || BiomeDatabase.contains(b, BiomeDictionary.Type.BEACH);
                if (!notLake && (water = v.blockCount2(world, Blocks.field_150355_j, 3)) > 4) {
                    biome = BiomeType.LAKE.getType();
                    return biome;
                }
                if (world instanceof ServerWorld && (server = (ServerWorld)world).func_217483_b_(pos = v.getPos())) {
                    biome = BiomeType.VILLAGE.getType();
                }
                return biome;
            }
            return -1;
        }
    }
}

