/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thut.core.client.render.animation.AnimationComponent;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.animation.AnimationXML;

@OnlyIn(value=Dist.CLIENT)
public class Animation {
    public final UUID id = UUID.randomUUID();
    public String name = "";
    public String identifier = "";
    public int length = -1;
    public int priority = 10;
    public boolean loops = true;
    public TreeMap<String, ArrayList<AnimationComponent>> sets = new TreeMap(Ordering.natural());

    public ArrayList<AnimationComponent> getComponents(String key) {
        return this.sets.get(key);
    }

    public int getLength() {
        if (this.length == -1) {
            this.initLength();
        }
        return this.length;
    }

    public Animation init(AnimationXML.Phase tag, @Nullable AnimationRegistry.IPartRenamer renamer) {
        return this;
    }

    protected String get(AnimationXML.Phase phase, QName value) {
        return phase.values.getOrDefault(value, "");
    }

    protected String get(AnimationXML.Phase phase, String value) {
        return phase.values.getOrDefault(new QName(value), "");
    }

    public void initLength() {
        this.length = -1;
        for (Map.Entry<String, ArrayList<AnimationComponent>> entry : this.sets.entrySet()) {
            for (AnimationComponent component : entry.getValue()) {
                this.length = Math.max(this.length, component.startKey + component.length);
            }
        }
    }

    public String toString() {
        return this.name + "|" + this.identifier + "|" + this.loops + "|" + this.getLength();
    }
}

