/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.DyeColor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thut.api.entity.IMobColourable;
import thut.api.entity.IShearable;
import thut.api.entity.ShearableCaps;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.IAnimationChanger;

public class AnimationChanger
implements IAnimationChanger {
    @CapabilityInject(value=IMobColourable.class)
    public static final Capability<IMobColourable> CAPABILITY = null;
    List<IAnimationChanger> children = Lists.newArrayList();
    public final Set<String> shearables = Sets.newHashSet();
    public final Set<String> dyeables = Sets.newHashSet();
    public final Map<String, Function<Integer, Integer>> colourOffsets = Maps.newHashMap();
    public final Map<String, IAnimationChanger.WornOffsets> wornOffsets = Maps.newHashMap();
    private final Set<String> checkWildCard = Sets.newHashSet();

    @Override
    public void addChild(IAnimationChanger animationRandomizer) {
        this.children.add(animationRandomizer);
    }

    private void checkWildCard(String partIdentifier) {
        if (!this.checkWildCard.contains(partIdentifier)) {
            this.checkWildCard.add(partIdentifier);
            for (String s : this.dyeables) {
                if (!s.startsWith("*") || !partIdentifier.matches(s.substring(1))) continue;
                this.dyeables.add(partIdentifier);
                if (!this.colourOffsets.containsKey(s)) break;
                this.colourOffsets.put(partIdentifier, this.colourOffsets.get(s));
                break;
            }
            for (String s : this.shearables) {
                if (!s.startsWith("*") || !partIdentifier.matches(s.substring(1))) continue;
                this.dyeables.add(partIdentifier);
                break;
            }
        }
    }

    @Override
    public int getColourForPart(String partIdentifier, Entity entity, int default_) {
        this.checkWildCard(partIdentifier);
        if (this.dyeables.contains(partIdentifier)) {
            int rgba = -16777216;
            IMobColourable pokemob = (IMobColourable)entity.getCapability(CAPABILITY).orElse(null);
            if (pokemob != null) {
                Function<Integer, Integer> offset = this.colourOffsets.get(partIdentifier);
                int colour = pokemob.getDyeColour() & 0xF;
                if (offset != null) {
                    colour = offset.apply(colour);
                }
                return rgba += DyeColor.func_196056_a((int)colour).field_218390_z;
            }
        }
        for (IAnimationChanger child : this.children) {
            int var = child.getColourForPart(partIdentifier, entity, default_);
            if (var == default_) continue;
            return var;
        }
        return default_;
    }

    @Override
    public IAnimationChanger.WornOffsets getOffsets(String part) {
        return this.wornOffsets.get(part);
    }

    @Override
    public void init(Set<Animation> existingAnimations) {
        for (IAnimationChanger child : this.children) {
            child.init(existingAnimations);
        }
    }

    @Override
    public boolean isPartHidden(String part, Entity entity, boolean default_) {
        this.checkWildCard(part);
        for (IAnimationChanger child : this.children) {
            if (!child.isPartHidden(part, entity, default_)) continue;
            return true;
        }
        IShearable shear = ShearableCaps.get((ICapabilityProvider)entity);
        if (this.shearables.contains(part) && shear != null) {
            return shear.isSheared();
        }
        return default_;
    }

    @Override
    public String modifyAnimation(MobEntity entity, float partialTicks, String phase) {
        for (IAnimationChanger child : this.children) {
            String mod = child.modifyAnimation(entity, partialTicks, phase);
            if (phase.equals(mod)) continue;
            return mod;
        }
        return phase;
    }

    @Override
    public void parseDyeables(Set<String> set) {
        this.dyeables.addAll(set);
    }

    @Override
    public void parseShearables(Set<String> set) {
        this.shearables.addAll(set);
    }

    @Override
    public void parseWornOffsets(Map<String, IAnimationChanger.WornOffsets> map) {
        this.wornOffsets.putAll(map);
    }
}

