/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationComponent;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IExtendedModelPart;

public class AnimationHelper {
    private static final Map<UUID, CapabilityAnimation.IAnimationHolder> holderMap = Maps.newHashMap();

    public static boolean animate(Animation animation, CapabilityAnimation.IAnimationHolder animate, String partName, IExtendedModelPart part, float partialTick, float limbSwing, int tick) {
        ArrayList<AnimationComponent> components = animation.getComponents(partName);
        boolean animated = false;
        Vector3 temp = Vector3.getNewVector();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float sx = 1.0f;
        float sy = 1.0f;
        float sz = 1.0f;
        int aniTick = tick;
        float time1 = aniTick;
        float time2 = 0.0f;
        int animationLength = animation.getLength();
        float limbSpeedFactor = 3.0f;
        time1 = (time1 + partialTick) % (float)animationLength;
        time2 = limbSwing * 3.0f % (float)animationLength;
        aniTick = (int)time1;
        if (components != null) {
            for (AnimationComponent component : components) {
                float time;
                float f = time = component.limbBased ? time2 : time1;
                if (component.limbBased) {
                    aniTick = (int)time2;
                }
                if (!(time >= (float)component.startKey)) continue;
                animated = true;
                float componentTimer = time - (float)component.startKey;
                if (componentTimer > (float)component.length) {
                    componentTimer = component.length;
                }
                temp.addTo(component.posChange[0] / (double)component.length * (double)componentTimer + component.posOffset[0], component.posChange[1] / (double)component.length * (double)componentTimer + component.posOffset[1], component.posChange[2] / (double)component.length * (double)componentTimer + component.posOffset[2]);
                x += (float)(component.rotChange[0] / (double)component.length * (double)componentTimer + component.rotOffset[0]);
                y += (float)(component.rotChange[1] / (double)component.length * (double)componentTimer + component.rotOffset[1]);
                z += (float)(component.rotChange[2] / (double)component.length * (double)componentTimer + component.rotOffset[2]);
                sx += (float)(component.scaleChange[0] / (double)component.length * (double)componentTimer + component.scaleOffset[0]);
                sy += (float)(component.scaleChange[1] / (double)component.length * (double)componentTimer + component.scaleOffset[1]);
                sz += (float)(component.scaleChange[2] / (double)component.length * (double)componentTimer + component.scaleOffset[2]);
                part.setHidden(component.hidden);
            }
        }
        if (animated) {
            part.setPreTranslations(temp);
            part.setPreScale(temp.set(sx, sy, sz));
            Vector4 angle = null;
            if (z != 0.0f) {
                angle = new Vector4(0.0, 0.0, 1.0, z);
            }
            if (x != 0.0f) {
                angle = angle != null ? angle.addAngles(new Vector4(1.0, 0.0, 0.0, x)) : new Vector4(1.0, 0.0, 0.0, x);
            }
            if (y != 0.0f) {
                angle = angle != null ? angle.addAngles(new Vector4(0.0, 1.0, 0.0, y)) : new Vector4(0.0, 1.0, 0.0, y);
            }
            if (angle != null) {
                part.setPreRotations(angle);
            }
        }
        return animated;
    }

    public static boolean doAnimation(List<Animation> list, Entity entity, String partName, IExtendedModelPart part, float partialTick, float limbSwing) {
        boolean animate = false;
        CapabilityAnimation.IAnimationHolder holder = AnimationHelper.getHolder(entity);
        if (holder != null) {
            for (Animation animation : list) {
                animate = AnimationHelper.animate(animation, holder, partName, part, partialTick, limbSwing, entity.field_70173_aa) || animate;
            }
        }
        return animate;
    }

    public static CapabilityAnimation.IAnimationHolder getHolder(Entity mob) {
        CapabilityAnimation.IAnimationHolder cap = (CapabilityAnimation.IAnimationHolder)mob.getCapability(CapabilityAnimation.CAPABILITY, null).orElse(null);
        if (cap != null) {
            return cap;
        }
        if (holderMap.containsKey(mob.func_110124_au())) {
            return holderMap.get(holderMap.get(mob.func_110124_au()));
        }
        CapabilityAnimation.DefaultImpl holder = new CapabilityAnimation.DefaultImpl();
        holderMap.put(mob.func_110124_au(), holder);
        return holder;
    }
}

