/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.w3c.dom.Node;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationBuilder;
import thut.core.client.render.animation.AnimationChanger;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.animation.ModelHolder;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.TextureHelper;
import thut.core.common.ThutCore;

public class AnimationLoader {
    public static void addStrings(String key, Set<String> toAddTo) {
        String[] names;
        if (key == null) {
            return;
        }
        for (String s : names = key.split(":")) {
            toAddTo.add(ThutCore.trim(s));
        }
    }

    public static Vector3 getVector3(String shift, Vector3 default_) {
        if (shift == null || shift.isEmpty()) {
            return default_;
        }
        Vector3 vect = Vector3.getNewVector().set(default_);
        String[] r = shift.split(",");
        if (r.length == 1) {
            vect.set(Float.parseFloat(r[0].trim()), Float.parseFloat(r[0].trim()), Float.parseFloat(r[0].trim()));
        } else if (r.length == 3) {
            vect.set(Float.parseFloat(r[0].trim()), Float.parseFloat(r[1].trim()), Float.parseFloat(r[2].trim()));
        }
        return vect;
    }

    public static IModelRenderer.Vector5 getRotation(String rotation, String time, IModelRenderer.Vector5 default_) {
        if (rotation == null || rotation.isEmpty()) {
            return default_;
        }
        time = time == null ? "0" : time;
        Vector4 ro = new Vector4();
        int t = 0;
        String[] r = rotation.split(",");
        t = Integer.parseInt(time);
        try {
            ro.set(Float.parseFloat(r[0].trim()), Float.parseFloat(r[1].trim()), Float.parseFloat(r[2].trim()), Float.parseFloat(r[3].trim()));
        }
        catch (Exception e) {
            ro.set(0.0f, 1.0f, 0.0f, 0.0f);
        }
        return new IModelRenderer.Vector5(ro, t);
    }

    public static void parse(InputStream stream, ModelHolder holder, IModel model, IModelRenderer<?> renderer) {
        try {
            AnimationXML.XMLFile file = AnimationXML.load(stream);
            int headDir = 2;
            int headDir2 = 2;
            int headAxis = 2;
            int headAxis2 = 1;
            float[] headCaps = new float[]{-100.0f, 100.0f};
            float[] headCaps1 = new float[]{-30.0f, 70.0f};
            Vector3 offset = Vector3.getNewVector();
            IModelRenderer.Vector5 rotation = new IModelRenderer.Vector5();
            Vector3 scale = Vector3.getNewVector();
            IPartTexturer texturer = renderer.getTexturer();
            IAnimationChanger animator = renderer.getAnimationChanger();
            if (texturer == null) {
                texturer = new TextureHelper();
                renderer.setTexturer(texturer);
            }
            if (animator == null) {
                animator = new AnimationChanger();
                renderer.setAnimationChanger(animator);
            }
            HashSet headNames = Sets.newHashSet();
            HashSet shear = Sets.newHashSet();
            HashSet dye = Sets.newHashSet();
            ArrayList tblAnims = Lists.newArrayList();
            HashMap mergedAnimations = Maps.newHashMap();
            HashMap wornOffsets = Maps.newHashMap();
            HashMap<String, ArrayList<IModelRenderer.Vector5>> phaseList = new HashMap<String, ArrayList<IModelRenderer.Vector5>>();
            AnimationXML.Metadata meta = file.model.metadata;
            if (meta != null) {
                AnimationLoader.addStrings(meta.head, headNames);
                AnimationLoader.addStrings(meta.shear, shear);
                AnimationLoader.addStrings(meta.dye, dye);
                headDir = meta.headDir;
                headDir2 = meta.headDir2;
                headAxis = meta.headAxis;
                headAxis2 = meta.headAxis2;
                AnimationLoader.setHeadCaps(meta.headCap, headCaps);
                AnimationLoader.setHeadCaps(meta.headCap1, headCaps1);
            }
            for (AnimationXML.Phase phase : file.model.phases) {
                if (phase.name != null) {
                    String string = ThutCore.trim(phase.name);
                    if (string.equals("global")) {
                        offset = AnimationLoader.getVector3(phase.values.get(new QName("offset")), offset);
                        scale = AnimationLoader.getVector3(phase.values.get(new QName("scale")), scale);
                        rotation = AnimationLoader.getRotation(phase.values.get(new QName("rotation")), null, rotation);
                        continue;
                    }
                    if (string.equals("textures")) {
                        texturer.applyTexturePhase(phase);
                        continue;
                    }
                    if (!AnimationRegistry.animations.containsKey(string)) continue;
                    ThutCore.LOGGER.debug("Loading " + string + " for " + holder.name);
                    try {
                        Animation anim = AnimationRegistry.make(phase, null);
                        if (anim == null) continue;
                        tblAnims.add(anim);
                    }
                    catch (Exception e) {
                        ThutCore.LOGGER.error("Error with animation for model: " + holder.name + " Anim: " + string, (Throwable)e);
                    }
                    continue;
                }
                if (phase.type == null) continue;
                ThutCore.LOGGER.debug("Building Animation " + phase.type + " for " + holder.name);
                Animation animation = AnimationBuilder.build(phase, model.getParts().keySet(), null);
                if (animation == null) continue;
                tblAnims.add(animation);
            }
            for (AnimationXML.Merge merge : file.model.merges) {
                String[] stringArray = merge.merge.split("->");
                mergedAnimations.put(ThutCore.trim(stringArray[0]), ThutCore.trim(stringArray[1]));
            }
            for (AnimationXML.Worn worn : file.model.worn) {
                Vector3 vector3 = AnimationLoader.getVector3(worn.offset, null);
                Vector3 w_angles = AnimationLoader.getVector3(worn.angles, null);
                Vector3 w_scale = AnimationLoader.getVector3(worn.scale, null);
                String w_parent = worn.parent;
                String w_ident = worn.id;
                wornOffsets.put(w_ident, new IAnimationChanger.WornOffsets(w_parent, vector3, w_scale, w_angles));
            }
            if (file.model.customTex != null) {
                texturer.init(file.model.customTex);
                if (file.model.customTex.defaults != null) {
                    holder.texture = new ResourceLocation(holder.texture.toString().replace(holder.name, ThutCore.trim(file.model.customTex.defaults)));
                }
            }
            for (AnimationXML.Mat mat : file.model.materials) {
                model.updateMaterial(mat);
            }
            IModelRenderer<?> loaded = renderer;
            loaded.updateModel(phaseList, holder);
            loaded.setRotationOffset(offset);
            loaded.setScale(scale);
            loaded.setRotations(rotation);
            model.getHeadParts().addAll(headNames);
            for (Animation animation : tblAnims) {
                ArrayList anims = loaded.getAnimations().get(animation.name);
                if (anims == null) {
                    anims = Lists.newArrayList();
                    loaded.getAnimations().put(animation.name, anims);
                }
                anims.add((Animation)animation);
            }
            for (String string : mergedAnimations.keySet()) {
                if (!loaded.getAnimations().containsKey(string)) continue;
                String to = (String)mergedAnimations.get(string);
                if (!loaded.getAnimations().containsKey(to)) continue;
                ArrayList fromSet = Lists.newArrayList();
                List<Animation> toSet = loaded.getAnimations().get(to);
                for (Animation anim : loaded.getAnimations().get(string)) {
                    Animation newAnim = new Animation();
                    newAnim.identifier = anim.identifier;
                    newAnim.name = to;
                    newAnim.loops = anim.loops;
                    newAnim.priority = 20;
                    newAnim.length = -1;
                    for (String s : anim.sets.keySet()) {
                        newAnim.sets.put(s, Lists.newArrayList((Iterable)anim.sets.get(s)));
                    }
                    fromSet.add(newAnim);
                }
                toSet.addAll(fromSet);
            }
            for (List<Animation> list : loaded.getAnimations().values()) {
                AnimationBuilder.processAnimations(list);
            }
            animator.parseDyeables(dye);
            animator.parseShearables(shear);
            HashSet hashSet = Sets.newHashSet();
            animator.init(hashSet);
            animator.parseWornOffsets(wornOffsets);
            loaded.setTexturer(texturer);
            loaded.setAnimationChanger(animator);
            if (model.getHeadInfo() != null) {
                if (headDir2 == 2) {
                    headDir2 = headDir;
                }
                if (headDir != 2) {
                    model.getHeadInfo().yawDirection = headDir;
                }
                if (headDir2 != 2) {
                    model.getHeadInfo().pitchDirection = headDir2;
                }
                model.getHeadInfo().yawAxis = headAxis;
                model.getHeadInfo().pitchAxis = headAxis2;
                model.getHeadInfo().yawCapMin = headCaps[0];
                model.getHeadInfo().yawCapMax = headCaps[1];
                model.getHeadInfo().pitchCapMin = headCaps1[0];
                model.getHeadInfo().pitchCapMax = headCaps1[1];
            }
            model.preProcessAnimations(loaded.getAnimations().values());
            stream.close();
        }
        catch (Exception e) {
            ThutCore.LOGGER.debug("No Animation found for " + holder.name + " " + holder.model, (Throwable)e);
        }
    }

    public static boolean parse(ModelHolder holder, IModel model, IModelRenderer<?> renderer, ResourceLocation animations) {
        try {
            IResource res = Minecraft.func_71410_x().func_195551_G().func_199002_a(animations);
            InputStream stream = res.func_199027_b();
            ThutCore.LOGGER.debug("Loading " + animations + " for " + holder.name);
            AnimationLoader.parse(stream, holder, model, renderer);
            res.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void parse(ModelHolder holder, IModel model, IModelRenderer<?> renderer) {
        ResourceLocation anims = holder.animation;
        if (!AnimationLoader.parse(holder, model, renderer, anims)) {
            for (ResourceLocation loc : holder.backupAnimations) {
                if (!AnimationLoader.parse(holder, model, renderer, loc)) continue;
                return;
            }
        } else {
            return;
        }
        ThutCore.LOGGER.error("Error in parsing animation file {} for {}, also checked {}", (Object)holder.animation, (Object)holder.name, holder.backupAnimations);
    }

    public static void setHeadCaps(String toSplit, float[] toFill) {
        String[] r = toSplit.split(",");
        toFill[0] = Float.parseFloat(r[0]);
        toFill[1] = Float.parseFloat(r[1]);
    }

    public static void setHeadCaps(Node node, float[] toFill, float[] toFill1) {
        if (node.getAttributes() == null) {
            return;
        }
        if (node.getAttributes().getNamedItem("headCap") != null) {
            AnimationLoader.setHeadCaps(node.getAttributes().getNamedItem("headCap").getNodeValue(), toFill);
        }
        if (node.getAttributes().getNamedItem("headCap1") != null) {
            AnimationLoader.setHeadCaps(node.getAttributes().getNamedItem("headCap1").getNodeValue(), toFill1);
        }
    }
}

