/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.prefab.AdvancedFlapAnimation;
import thut.core.client.render.animation.prefab.BasicFlapAnimation;
import thut.core.client.render.animation.prefab.BiWalkAnimation;
import thut.core.client.render.animation.prefab.QuadWalkAnimation;
import thut.core.client.render.animation.prefab.SnakeMovement;
import thut.core.common.ThutCore;

public class AnimationRegistry {
    public static HashMap<String, Class<? extends Animation>> animations = Maps.newHashMap();
    public static HashMap<String, String> animationPhases = Maps.newHashMap();

    public static Animation make(AnimationXML.Phase map, @Nullable IPartRenamer renamer) {
        String name = map.name;
        if (name == null) {
            return null;
        }
        name = ThutCore.trim(name);
        Animation ret = null;
        Class<? extends Animation> toMake = animations.get(name);
        if (toMake != null) {
            try {
                ret = toMake.newInstance();
                ret.init(map, renamer);
                if (animationPhases.containsKey(name)) {
                    ret.name = animationPhases.get(name);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    static {
        animations.put("quadwalk", QuadWalkAnimation.class);
        animations.put("biwalk", BiWalkAnimation.class);
        animations.put("flap", BasicFlapAnimation.class);
        animations.put("advflap", AdvancedFlapAnimation.class);
        animations.put("snakewalk", SnakeMovement.class);
        animations.put("snakefly", SnakeMovement.class);
        animationPhases.put("snakefly", "flying");
        animations.put("snakeidle", SnakeMovement.class);
        animationPhases.put("snakeidle", "idle");
        animations.put("snakeswim", SnakeMovement.class);
        animationPhases.put("snakeswim", "swimming");
    }

    public static interface IPartRenamer {
        public void convertToIdents(String[] var1);
    }
}

