/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.core.client.render.animation.Animation;

public class CapabilityAnimation {
    private static final Set<Class<? extends Entity>> ANIMATE = Sets.newHashSet();
    private static final ResourceLocation ANIM = new ResourceLocation("thutcore:animations");
    @CapabilityInject(value=IAnimationHolder.class)
    public static final Capability<IAnimationHolder> CAPABILITY = null;

    @SubscribeEvent
    public static void attachCap(AttachCapabilitiesEvent<Entity> event) {
        if (ANIMATE.contains(((Entity)event.getObject()).getClass())) {
            event.addCapability(ANIM, (ICapabilityProvider)new DefaultImpl());
        }
    }

    public static void registerAnimateClass(Class<? extends Entity> clazz) {
        ANIMATE.add(clazz);
    }

    public static void setup() {
        CapabilityManager.INSTANCE.register(IAnimationHolder.class, (Capability.IStorage)new Storage(), DefaultImpl::new);
        MinecraftForge.EVENT_BUS.register(CapabilityAnimation.class);
    }

    private static class Storage
    implements Capability.IStorage<IAnimationHolder> {
        private Storage() {
        }

        public void readNBT(Capability<IAnimationHolder> capability, IAnimationHolder instance, Direction side, INBT nbt) {
        }

        public INBT writeNBT(Capability<IAnimationHolder> capability, IAnimationHolder instance, Direction side) {
            return null;
        }
    }

    public static interface IAnimationHolder {
        public void clean();

        public Set<Animation> getPendingAnimations();

        public Set<Animation> getPlaying();

        public void setPendingAnimations(List<Animation> var1, float var2);

        public void setStep(Animation var1, float var2);

        public String getAnimation(Entity var1);
    }

    public static class DefaultImpl
    implements IAnimationHolder,
    ICapabilityProvider {
        private final LazyOptional<IAnimationHolder> holder = LazyOptional.of(() -> this);
        Map<Animation, Float> stepsMap = Maps.newHashMap();
        Set<Animation> playing = Sets.newHashSet();
        private final Set<Animation> pending = Sets.newHashSet();

        @Override
        public void clean() {
            this.stepsMap.clear();
            this.pending.clear();
            this.playing.clear();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.holder);
        }

        @Override
        public Set<Animation> getPendingAnimations() {
            return this.pending;
        }

        @Override
        public Set<Animation> getPlaying() {
            return this.playing;
        }

        @Override
        public void setPendingAnimations(List<Animation> name, float step) {
            if (name != null) {
                this.pending.addAll(name);
                for (Animation anim : name) {
                    this.stepsMap.put(anim, Float.valueOf(step));
                }
            } else {
                this.pending.clear();
            }
            if (this.playing.isEmpty()) {
                this.playing.addAll(name);
            } else {
                this.pending.addAll(name);
            }
        }

        @Override
        public void setStep(Animation animation, float step) {
            float time = step - this.stepsMap.put(animation, Float.valueOf(step)).floatValue();
            if (time > (float)animation.getLength()) {
                this.playing.remove(animation);
                if (this.playing.isEmpty()) {
                    this.playing.addAll(this.pending);
                    this.pending.clear();
                }
            }
        }

        @Override
        public String getAnimation(Entity entityIn) {
            return "idle";
        }
    }
}

