/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import thut.api.maths.Vector3;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModelRenderer;

public interface IModel {
    public static final ImmutableSet<String> emptyAnims = ImmutableSet.of();

    public void applyAnimation(Entity var1, CapabilityAnimation.IAnimationHolder var2, IModelRenderer<?> var3, float var4, float var5);

    default public Set<String> getBuiltInAnimations() {
        return emptyAnims;
    }

    public HeadInfo getHeadInfo();

    public Set<String> getHeadParts();

    public HashMap<String, IExtendedModelPart> getParts();

    default public void globalFix(float dx, float dy, float dz) {
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)(dy - 1.5f));
    }

    public boolean isValid();

    public void preProcessAnimations(Collection<List<Animation>> var1);

    default public void setHeadInfo(HeadInfo in) {
    }

    default public void setOffset(Vector3 offset) {
    }

    default public void updateMaterial(AnimationXML.Mat mat) {
        for (IExtendedModelPart part : this.getParts().values()) {
            part.updateMaterial(mat);
        }
    }

    public static class HeadInfo {
        public float headYaw;
        public float headPitch;
        public int currentTick = 0;
        public int lastTick = 0;
        public float yawCapMax = 180.0f;
        public float yawCapMin = -180.0f;
        public float pitchCapMax = 40.0f;
        public float pitchCapMin = -40.0f;
        public int yawAxis = 1;
        public int pitchAxis = 0;
        public int yawDirection = 1;
        public int pitchDirection = 1;
    }
}

