/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationHelper;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.animation.ModelHolder;
import thut.core.client.render.model.IModel;
import thut.core.client.render.texturing.IPartTexturer;

public interface IModelRenderer<T extends MobEntity> {
    public static final String DEFAULTPHASE = "idle";
    public static final Vector3 DEFAULTSCALE = Vector3.getNewVector().set(1);

    public void doRender(T var1, double var2, double var4, double var6, float var8, float var9);

    default public String getAnimation(Entity entityIn) {
        CapabilityAnimation.IAnimationHolder holder = AnimationHelper.getHolder(entityIn);
        if (holder != null) {
            return holder.getAnimation(entityIn);
        }
        return DEFAULTPHASE;
    }

    public IAnimationChanger getAnimationChanger();

    public HashMap<String, List<Animation>> getAnimations();

    default public Vector3 getRotationOffset() {
        return Vector3.empty;
    }

    @Nullable
    default public Vector5 getRotations() {
        return null;
    }

    default public Vector3 getScale() {
        return DEFAULTSCALE;
    }

    public IPartTexturer getTexturer();

    public boolean hasAnimation(String var1, Entity var2);

    public void scaleEntity(Entity var1, IModel var2, float var3);

    default public void setAnimation(String phase, Entity entity, float partialTick) {
        CapabilityAnimation.IAnimationHolder holder = AnimationHelper.getHolder(entity);
        List<Animation> anim = this.getAnimations().get(phase);
        if (holder != null && anim != null) {
            holder.setPendingAnimations(anim, (float)entity.field_70173_aa + partialTick);
        }
    }

    public void setAnimationChanger(IAnimationChanger var1);

    public void setRotationOffset(Vector3 var1);

    public void setRotations(Vector5 var1);

    public void setScale(Vector3 var1);

    public void setTexturer(IPartTexturer var1);

    public void updateModel(HashMap<String, ArrayList<Vector5>> var1, ModelHolder var2);

    public static class Vector5 {
        public Vector4 rotations;
        public int time;

        public Vector5() {
            this.time = 0;
            this.rotations = new Vector4();
        }

        public Vector5(Vector4 rotation, int time) {
            this.rotations = rotation;
            this.time = time;
        }

        public Vector5 interpolate(Vector5 v, float time, boolean wrap) {
            if (v.time == 0) {
                return this;
            }
            if (Double.isNaN(this.rotations.x)) {
                this.rotations = new Vector4();
            }
            Vector4 rotDiff = this.rotations.copy();
            if (this.rotations.x == this.rotations.z && this.rotations.z == this.rotations.y && this.rotations.y == this.rotations.w && this.rotations.w == 0.0f) {
                this.rotations.x = 1.0f;
            }
            if (!v.rotations.equals(this.rotations)) {
                rotDiff = v.rotations.subtractAngles(this.rotations);
                rotDiff = this.rotations.addAngles(rotDiff.scalarMult(time));
            }
            if (Double.isNaN(rotDiff.x)) {
                rotDiff = new Vector4(0.0, 1.0, 0.0, 0.0f);
            }
            Vector5 ret = new Vector5(rotDiff, v.time);
            return ret;
        }

        public String toString() {
            return "|r:" + this.rotations + "|t:" + this.time;
        }
    }
}

