/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model.parts;

import com.mojang.blaze3d.platform.GlStateManager;
import org.lwjgl.opengl.GL11;
import thut.api.maths.vecmath.Vector3f;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.TextureCoordinate;
import thut.core.common.ThutCore;

public abstract class Mesh {
    private int meshId = 0;
    protected final boolean hasTextures;
    public Vertex[] vertices;
    public Vertex[] normals;
    public TextureCoordinate[] textureCoordinates;
    public Integer[] order;
    final Vector3f[] normalList;
    private Material material;
    public String name;
    private final double[] uvShift = new double[]{0.0, 0.0};
    final int GL_FORMAT;

    public Mesh(Integer[] order, Vertex[] vert, Vertex[] norm, TextureCoordinate[] tex, int GL_FORMAT) {
        int i;
        int iter;
        this.order = order;
        this.vertices = vert;
        this.normals = norm;
        this.textureCoordinates = tex;
        this.hasTextures = tex != null;
        this.GL_FORMAT = GL_FORMAT;
        this.normalList = new Vector3f[this.order.length];
        int maxN = 0;
        for (Integer element : order) {
            maxN = Math.max(maxN, element);
        }
        int n = iter = GL_FORMAT == 4 ? 3 : 4;
        if (this.vertices.length > maxN) {
            for (i = 0; i < this.order.length; i += iter) {
                if (i + 2 >= order.length) {
                    Vector3f c;
                    this.normalList[i] = c = new Vector3f(0.0f, 1.0f, 0.0f);
                    this.normalList[i + 1] = c;
                    this.normalList[i + 2] = c;
                }
                Vertex vertex = this.vertices[this.order[i]];
                Vector3f v1 = new Vector3f(vertex.x, vertex.y, vertex.z);
                vertex = this.vertices[this.order[i + 1]];
                Vector3f v2 = new Vector3f(vertex.x, vertex.y, vertex.z);
                vertex = this.vertices[this.order[i + 2]];
                Vector3f v3 = new Vector3f(vertex.x, vertex.y, vertex.z);
                Vector3f a = new Vector3f(v2);
                a.sub(v1);
                Vector3f b = new Vector3f(v3);
                b.sub(v1);
                Vector3f c = new Vector3f();
                c.cross(a, b);
                c.normalize();
                this.normalList[i] = c;
                this.normalList[i + 1] = c;
                this.normalList[i + 2] = c;
                if (iter != 4) continue;
                this.normalList[i + 3] = c;
            }
        } else {
            ThutCore.LOGGER.error("Error with mesh", (Throwable)new IllegalArgumentException());
            for (i = 0; i < this.order.length; ++i) {
                this.normalList[i] = new Vector3f(0.0f, 1.0f, 0.0f);
            }
        }
    }

    protected void doRender(IPartTexturer texturer) {
        boolean flat = true;
        if (texturer != null) {
            flat = texturer.isFlat(this.name);
        }
        if (flat) {
            GL11.glShadeModel((int)7424);
        } else {
            GL11.glShadeModel((int)7425);
        }
        if (!this.hasTextures) {
            GlStateManager.disableTexture();
        }
        GL11.glBegin((int)this.GL_FORMAT);
        int n = 0;
        for (Integer i : this.order) {
            if (this.hasTextures) {
                TextureCoordinate textureCoordinate = this.textureCoordinates[i];
                GL11.glTexCoord2d((double)textureCoordinate.u, (double)textureCoordinate.v);
            }
            Vertex vertex = this.vertices[i];
            if (flat) {
                Vector3f norm = this.normalList[n];
                GL11.glNormal3f((float)norm.x, (float)norm.y, (float)norm.z);
            } else {
                Vertex normal = this.normals[i];
                GL11.glNormal3f((float)normal.x, (float)normal.y, (float)normal.z);
            }
            ++n;
            GL11.glVertex3f((float)vertex.x, (float)vertex.y, (float)vertex.z);
        }
        GL11.glEnd();
        if (!flat) {
            GL11.glShadeModel((int)7424);
        }
        if (!this.hasTextures) {
            GlStateManager.enableTexture();
        }
    }

    private void compileList(IPartTexturer texturer) {
        if (!GL11.glIsList((int)this.meshId)) {
            if (this.material != null && texturer != null && !texturer.hasMapping(this.material.name) && this.material.texture != null) {
                texturer.addMapping(this.material.name, this.material.texture);
            }
            this.meshId = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.meshId, (int)4864);
            this.doRender(texturer);
            GL11.glEndList();
        }
    }

    public void renderShape(IPartTexturer texturer) {
        this.compileList(texturer);
        boolean textureShift = false;
        if (texturer != null) {
            texturer.applyTexture(this.name);
            textureShift = texturer.shiftUVs(this.name, this.uvShift);
            if (textureShift) {
                GL11.glMatrixMode((int)5890);
                GL11.glTranslated((double)this.uvShift[0], (double)this.uvShift[1], (double)0.0);
                GL11.glMatrixMode((int)5888);
            }
        }
        if (this.material != null) {
            this.material.preRender();
        }
        GL11.glCallList((int)this.meshId);
        GL11.glFlush();
        if (this.material != null) {
            this.material.postRender();
        }
        if (textureShift) {
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
        }
    }

    public void setMaterial(Material material) {
        this.material = material;
        this.name = material.name;
    }
}

