/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.model.parts;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.opengl.GL11;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.api.maths.vecmath.Vector3f;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.Vertex;
import thut.core.client.render.model.parts.Material;
import thut.core.client.render.model.parts.Mesh;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.client.render.texturing.IRetexturableModel;
import thut.core.common.ThutCore;

public abstract class Part
implements IExtendedModelPart,
IRetexturableModel {
    public List<Mesh> shapes = Lists.newArrayList();
    private final HashMap<String, IExtendedModelPart> childParts = new HashMap();
    private final String name;
    private IExtendedModelPart parent = null;
    IPartTexturer texturer;
    IAnimationChanger changer;
    public Vector4 preRot = new Vector4();
    public Vector4 postRot = new Vector4();
    public Vector4 postRot1 = new Vector4();
    public Vector3 preTrans = Vector3.getNewVector();
    public Vector3 postTrans = Vector3.getNewVector();
    public Vertex preScale = new Vertex(1.0f, 1.0f, 1.0f);
    public Vector3 offset = Vector3.getNewVector();
    public Vector4 rotations = new Vector4();
    public Vertex scale = new Vertex(1.0f, 1.0f, 1.0f);
    public int red = 255;
    public int green = 255;
    public int blue = 255;
    public int alpha = 255;
    public int brightness = 0xF00000;
    private final int[] rgbab = new int[5];
    private boolean hidden = false;

    public Part(String name) {
        this.name = name;
    }

    @Override
    public void addChild(IExtendedModelPart subPart) {
        this.childParts.put(subPart.getName(), subPart);
        subPart.setParent(this);
    }

    public void addForRender() {
        GL11.glColor4f((float)((float)this.red / 255.0f), (float)((float)this.green / 255.0f), (float)((float)this.blue / 255.0f), (float)((float)this.alpha / 255.0f));
        for (Mesh s : this.shapes) {
            s.renderShape(this.texturer);
        }
    }

    @Override
    public Vector4 getDefaultRotations() {
        return this.rotations;
    }

    @Override
    public Vector3 getDefaultTranslations() {
        return this.offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IExtendedModelPart getParent() {
        return this.parent;
    }

    @Override
    public int[] getRGBAB() {
        this.rgbab[0] = this.red;
        this.rgbab[1] = this.green;
        this.rgbab[2] = this.blue;
        this.rgbab[3] = this.alpha;
        this.rgbab[4] = this.brightness;
        return this.rgbab;
    }

    public HashMap<String, IExtendedModelPart> getSubParts() {
        return this.childParts;
    }

    private void postRender() {
        GL11.glScalef((float)(1.0f / this.scale.x), (float)(1.0f / this.scale.y), (float)(1.0f / this.scale.z));
        this.postRot1.glRotateMinus();
        this.postRot.glRotateMinus();
        GL11.glTranslated((double)(-this.offset.x), (double)(-this.offset.y), (double)(-this.offset.z));
    }

    private void preRender() {
        this.rotateToParent();
        GL11.glTranslated((double)this.offset.x, (double)this.offset.y, (double)this.offset.z);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)this.preTrans.x, (double)this.preTrans.y, (double)this.preTrans.z);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.rotations.glRotate();
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.preRot.glRotate();
        GL11.glTranslated((double)this.postTrans.x, (double)this.postTrans.y, (double)this.postTrans.z);
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.postRot.glRotate();
        this.postRot1.glRotate();
        GL11.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
    }

    public void render() {
        GL11.glScalef((float)this.preScale.x, (float)this.preScale.y, (float)this.preScale.z);
        if (this.hidden) {
            return;
        }
        this.preRender();
        this.addForRender();
        this.postRender();
    }

    @Override
    public void renderAll() {
        this.render();
        for (IExtendedModelPart o : this.childParts.values()) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)this.offset.x, (double)this.offset.y, (double)this.offset.z);
            GL11.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
            o.renderAll();
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderAllExcept(String ... excludedGroupNames) {
        String s1;
        boolean skip = this.hidden;
        String[] stringArray = excludedGroupNames;
        int n = stringArray.length;
        for (int i = 0; i < n && !(skip = (s1 = stringArray[i]).equalsIgnoreCase(this.name)); ++i) {
        }
        if (!skip) {
            this.render();
            for (IExtendedModelPart o : this.childParts.values()) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)this.offset.x, (double)this.offset.y, (double)this.offset.z);
                GL11.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
                o.renderAllExcept(excludedGroupNames);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void renderOnly(String ... groupNames) {
        boolean rendered = false;
        for (String s1 : groupNames) {
            rendered = s1.equalsIgnoreCase(this.name);
            if (!rendered) continue;
            this.preRender();
            this.render();
            this.postRender();
            break;
        }
        if (rendered) {
            for (IExtendedModelPart o : this.childParts.values()) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)this.offset.x, (double)this.offset.y, (double)this.offset.z);
                GL11.glScalef((float)this.scale.x, (float)this.scale.y, (float)this.scale.z);
                o.renderOnly(groupNames);
                GL11.glPopMatrix();
            }
        }
    }

    @Override
    public void renderPart(String partName) {
        this.renderOnly(partName);
    }

    @Override
    public void resetToInit() {
        this.preRot.set(0.0f, 1.0f, 0.0f, 0.0f);
        this.postRot.set(0.0f, 1.0f, 0.0f, 0.0f);
        this.postRot1.set(0.0f, 1.0f, 0.0f, 0.0f);
        this.preTrans.clear();
        this.postTrans.clear();
        this.hidden = false;
    }

    private void rotateToParent() {
        if (this.parent != null && this.parent instanceof Part) {
            Part parent = (Part)this.parent;
            parent.postRot.glRotate();
            parent.postRot1.glRotate();
        }
    }

    @Override
    public void setAnimationChanger(IAnimationChanger changer) {
        this.changer = changer;
        for (IExtendedModelPart part : this.childParts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setAnimationChanger(changer);
        }
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public void setParent(IExtendedModelPart parent) {
        this.parent = parent;
    }

    @Override
    public void setPostRotations(Vector4 angles) {
        this.postRot = angles;
    }

    @Override
    public void setPostRotations2(Vector4 rotations) {
        this.postRot1 = rotations;
    }

    @Override
    public void setPostTranslations(Vector3 point) {
        this.postTrans.set(point);
    }

    @Override
    public void setPreRotations(Vector4 angles) {
        this.preRot = angles;
    }

    @Override
    public void setPreScale(Vector3 scale) {
        this.preScale.x = (float)scale.x;
        this.preScale.y = (float)scale.y;
        this.preScale.z = (float)scale.z;
    }

    @Override
    public void setPreTranslations(Vector3 point) {
        this.preTrans.set(point);
    }

    @Override
    public void setRGBAB(int[] array) {
        this.red = array[0];
        this.green = array[1];
        this.blue = array[2];
        this.alpha = array[3];
        this.brightness = array[4];
    }

    @Override
    public void setTexturer(IPartTexturer texturer) {
        this.texturer = texturer;
        for (IExtendedModelPart part : this.childParts.values()) {
            if (!(part instanceof IRetexturableModel)) continue;
            ((IRetexturableModel)((Object)part)).setTexturer(texturer);
        }
    }

    @Override
    public void updateMaterial(AnimationXML.Mat mat) {
        String mat_name = ThutCore.trim(mat.name);
        String[] parts = mat.name.split(":");
        Material material = new Material(mat_name);
        material.diffuseColor = new Vector3f(1.0f, 1.0f, 1.0f);
        material.emissiveColor = new Vector3f(mat.light, mat.light, mat.light);
        material.emissiveMagnitude = Math.min(1.0f, (float)((double)material.emissiveColor.length() / Math.sqrt(3.0)) / 0.8f);
        material.specularColor = new Vector3f(1.0f, 1.0f, 1.0f);
        material.transparency = mat.transluscent ? 1.0f : 0.0f;
        for (String s : parts) {
            for (Mesh mesh : this.shapes) {
                if (mesh.name == null) {
                    mesh.name = this.getName();
                }
                if (!mesh.name.equals(ThutCore.trim(s)) && !mesh.name.equals(mat_name)) continue;
                mesh.setMaterial(material);
            }
        }
    }
}

