/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.DyeColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.opengl.GL11;
import thut.api.maths.Vector3;
import thut.core.client.render.particle.IAnimatedParticle;
import thut.core.client.render.particle.IParticle;

public class ParticleBase
extends ParticleType<ParticleBase>
implements IParticle,
IAnimatedParticle,
IParticleData {
    private static final IParticleData.IDeserializer<ParticleBase> DESERIALIZER = new IParticleData.IDeserializer<ParticleBase>(){

        public ParticleBase deserialize(ParticleType<ParticleBase> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return ((ParticleBase)particleTypeIn).read(reader);
        }

        public ParticleBase read(ParticleType<ParticleBase> particleTypeIn, PacketBuffer buffer) {
            return ((ParticleBase)particleTypeIn).read(buffer);
        }
    };
    public static ResourceLocation TEXTUREMAP = new ResourceLocation("thutcore", "textures/particles.png");
    int duration = 10;
    int lifetime = 10;
    int initTime = 0;
    long lastTick = 0L;
    int animSpeed = 2;
    float size = 1.0f;
    int rgba = -1;
    boolean billboard = true;
    String name = "";
    Vector3 velocity = Vector3.empty;
    Vector3 position = Vector3.empty;
    int[][] tex = new int[1][2];

    public ParticleBase(int x, int y) {
        super(true, DESERIALIZER);
        this.tex[0][0] = x;
        this.tex[0][1] = y;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey((IForgeRegistryEntry)this).toString();
    }

    public ParticleType<?> func_197554_b() {
        return this;
    }

    @Override
    public void kill() {
    }

    @Override
    public long lastTick() {
        return this.lastTick;
    }

    public ParticleBase read(PacketBuffer buffer) {
        this.duration = buffer.readInt();
        this.lifetime = buffer.readInt();
        this.initTime = buffer.readInt();
        this.animSpeed = buffer.readInt();
        this.size = buffer.readFloat();
        this.rgba = buffer.readInt();
        this.billboard = buffer.readBoolean();
        this.velocity = Vector3.readFromBuff((ByteBuf)buffer);
        this.position = Vector3.readFromBuff((ByteBuf)buffer);
        this.tex = new int[buffer.readInt()][];
        for (int i = 0; i < this.tex.length; ++i) {
            this.tex[i] = buffer.func_186863_b();
        }
        return this;
    }

    protected ParticleBase read(StringReader reader) {
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderParticle(BufferBuilder buffer, ActiveRenderInfo entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        GL11.glPushMatrix();
        if (this.billboard) {
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.setColour();
        float alpha = (float)(this.rgba >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.rgba >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.rgba >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.rgba & 0xFF) / 255.0f;
        int num = this.getDuration() / this.animSpeed % this.tex.length;
        int u = this.tex[num][0];
        int v = this.tex[num][1];
        double u1 = (double)u * 1.0 / 16.0;
        double v1 = (double)v * 1.0 / 16.0;
        double u2 = (double)(u + 1) * 1.0 / 16.0;
        double v2 = (double)(v + 1) * 1.0 / 16.0;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTUREMAP);
        double x0 = -this.size;
        double y0 = -this.size;
        double z0 = 0.0;
        double x1 = 0.0;
        double y1 = this.size;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(x0, y0, 0.0).func_187315_a(u1, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(0.0, y0, 0.0).func_187315_a(u2, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(0.0, y1, 0.0).func_187315_a(u2, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x0, y1, 0.0).func_187315_a(u1, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x0, y0, 0.0).func_187315_a(u1, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x0, y1, 0.0).func_187315_a(u1, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(0.0, y1, 0.0).func_187315_a(u2, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(0.0, y0, 0.0).func_187315_a(u2, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    public void setAnimSpeed(int speed) {
        this.animSpeed = Math.max(speed, 5);
    }

    void setColour() {
        if (this.name.equalsIgnoreCase("aurora")) {
            this.rgba = -16777216;
            int num = (this.getDuration() + this.initTime) / this.animSpeed % 16;
            this.rgba += DyeColor.func_196056_a((int)num).field_218390_z;
        }
    }

    @Override
    public void setColour(int colour) {
        this.rgba = colour;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public void setLastTick(long tick) {
        this.lastTick = tick;
    }

    @Override
    public void setLifetime(int ticks) {
        this.duration = this.lifetime = ticks;
    }

    public void setPosition(Vector3 v) {
        this.position = v;
    }

    @Override
    public void setSize(float size) {
        this.size = size;
    }

    @Override
    public void setStartTime(int start) {
        this.initTime = start;
    }

    @Override
    public void setTex(int[][] textures) {
        this.tex = textures;
    }

    public void setVelocity(Vector3 v) {
        if (v == null) {
            v = Vector3.empty;
        }
        this.velocity = v;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeInt(this.duration);
        buffer.writeInt(this.lifetime);
        buffer.writeInt(this.initTime);
        buffer.writeInt(this.animSpeed);
        buffer.writeFloat(this.size);
        buffer.writeInt(this.rgba);
        buffer.writeBoolean(this.billboard);
        this.velocity.writeToBuff((ByteBuf)buffer);
        this.position.writeToBuff((ByteBuf)buffer);
        buffer.writeInt(this.tex.length);
        for (int[] element : this.tex) {
            buffer.func_186875_a(element);
        }
    }
}

