/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import thut.api.maths.Vector3;
import thut.core.client.render.particle.ParticleBase;
import thut.core.client.render.particle.ParticleNoGravity;
import thut.core.client.render.particle.ThutParticles;

@OnlyIn(value=Dist.CLIENT)
public class ParticleFactories {
    public static final RenderType TYPE = new RenderType();
    public static final IParticleFactory<ParticleBase> GENERICFACTORY = (type, world, x, y, z, vx, vy, vz) -> {
        type = ThutParticles.clone(type);
        type.setVelocity(Vector3.getNewVector().set(vx, vy, vz));
        type.setPosition(Vector3.getNewVector().set(x, y, z));
        return new ThutParticle(world, (ParticleBase)type);
    };

    public static class ThutParticle
    extends Particle {
        final ParticleBase particle;
        final World field_187122_b;

        protected ThutParticle(World worldIn, ParticleBase particleIn) {
            super(worldIn, particleIn.position.x, particleIn.position.y, particleIn.position.z);
            this.particle = particleIn;
            this.field_187122_b = worldIn;
            if (this.particle instanceof ParticleNoGravity) {
                this.field_70545_g = 0.0f;
            }
            this.field_187129_i = this.particle.velocity.x;
            this.field_187130_j = this.particle.velocity.z;
            this.field_187131_k = this.particle.velocity.y;
            this.func_187114_a(this.particle.lifetime);
        }

        public int func_206254_h() {
            return this.particle.lifetime;
        }

        public IParticleRenderType func_217558_b() {
            return IParticleRenderType.field_217605_e;
        }

        public boolean func_187113_k() {
            return this.particle.getDuration() >= 0;
        }

        public void func_180434_a(BufferBuilder buffer, ActiveRenderInfo entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            GL11.glPushMatrix();
            Vector3 source = Vector3.getNewVector();
            float x = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - Particle.field_70556_an);
            float y = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - Particle.field_70554_ao);
            float z = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - Particle.field_70555_ap);
            source.set(x, y, z);
            GL11.glTranslated((double)source.x, (double)source.y, (double)source.z);
            this.particle.renderParticle(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            GL11.glPopMatrix();
        }

        public void func_189213_a() {
            this.field_70546_d = 0;
            super.func_189213_a();
            this.particle.setDuration(this.particle.getDuration() - 1);
            this.particle.setLastTick(this.field_187122_b.func_82737_E());
            if (this.particle.getDuration() < 0) {
                this.particle.kill();
                this.func_187112_i();
            }
        }
    }

    public static class RenderType
    implements IParticleRenderType {
        public void func_217600_a(BufferBuilder builder, TextureManager textures) {
        }

        public void func_217599_a(Tessellator tes) {
        }
    }
}

