/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;
import thut.api.maths.Vector3;
import thut.core.client.render.particle.IParticle;

public class ParticleHandler {
    static List<ParticlePacket> particles = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParticle(Vector3 location, IParticle particle) {
        if (particle == null || location == null || Minecraft.func_71410_x().field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) {
            return;
        }
        List<ParticlePacket> list = particles;
        synchronized (list) {
            particles.add(new ParticlePacket(location.copy(), particle));
        }
    }

    public static void clear() {
        particles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderWorldPost(EntityViewRenderEvent.RenderFogEvent event) {
        try {
            List<ParticlePacket> list = particles;
            synchronized (list) {
                int i;
                GL11.glPushMatrix();
                ArrayList list2 = Lists.newArrayList();
                for (i = 0; i < particles.size(); ++i) {
                    ParticlePacket packet = particles.get(i);
                    IParticle particle = packet.particle;
                    Vector3 target = packet.location;
                    if (particle.getDuration() < 0) {
                        packet.kill();
                        list2.add(packet);
                        continue;
                    }
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    Vector3 source = Vector3.getNewVector().set(player.field_70142_S, player.field_70137_T, player.field_70136_U);
                    GL11.glPushMatrix();
                    source.set(target.subtract(source));
                    GL11.glTranslated((double)source.x, (double)source.y, (double)source.z);
                    double d0 = (-player.field_70165_t + player.field_70142_S) * event.getRenderPartialTicks();
                    double d1 = (-player.field_70163_u + player.field_70137_T) * event.getRenderPartialTicks();
                    double d2 = (-player.field_70161_v + player.field_70136_U) * event.getRenderPartialTicks();
                    source.set(d0, d1, d2);
                    GL11.glTranslated((double)source.x, (double)source.y, (double)source.z);
                    GL11.glPopMatrix();
                    if (particle.lastTick() != player.func_130014_f_().func_82737_E()) {
                        particle.setDuration(particle.getDuration() - 1);
                        particle.setLastTick(player.func_130014_f_().func_82737_E());
                    }
                    if (particle.getDuration() >= 0) continue;
                    packet.kill();
                    list2.add(packet);
                }
                GL11.glPopMatrix();
                for (i = 0; i < list2.size(); ++i) {
                    particles.remove(list2.get(i));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void WorldUnloadEvent(WorldEvent.Unload evt) {
        ParticleHandler.clear();
    }

    private static class ParticlePacket {
        final Vector3 location;
        final IParticle particle;

        public ParticlePacket(Vector3 v, IParticle p) {
            this.location = v;
            this.particle = p;
        }

        public void kill() {
            this.particle.kill();
        }
    }
}

