/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import com.mojang.brigadier.StringReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.network.PacketBuffer;
import org.lwjgl.opengl.GL11;
import thut.api.maths.Vector4;
import thut.core.client.render.particle.ParticleBase;

public class ParticleOrientable
extends ParticleBase {
    Vector4 orientation;

    public ParticleOrientable(int x, int y) {
        super(x, y);
        this.billboard = false;
    }

    @Override
    protected ParticleBase read(StringReader reader) {
        super.read(reader);
        return this;
    }

    @Override
    public ParticleBase read(PacketBuffer buffer) {
        super.read(buffer);
        this.orientation = new Vector4(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        return this;
    }

    @Override
    public void renderParticle(BufferBuilder buffer, ActiveRenderInfo entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        GL11.glPushMatrix();
        if (this.billboard) {
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.setColour();
        float alpha = (float)(this.rgba >> 24 & 0xFF) / 255.0f;
        float red = (float)(this.rgba >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.rgba >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.rgba & 0xFF) / 255.0f;
        int num = this.getDuration() / this.animSpeed % this.tex.length;
        int u = this.tex[num][0];
        int v = this.tex[num][1];
        double u1 = (double)u * 1.0 / 16.0;
        double v1 = (double)v * 1.0 / 16.0;
        double u2 = (double)(u + 1) * 1.0 / 16.0;
        double v2 = (double)(v + 1) * 1.0 / 16.0;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ParticleBase.TEXTUREMAP);
        double x0 = -this.size;
        double y0 = -this.size;
        double z0 = 0.0;
        double x1 = 0.0;
        double y1 = this.size;
        if (this.orientation != null) {
            this.orientation.glRotate();
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(x0, y0, 0.0).func_187315_a(u1, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(0.0, y0, 0.0).func_187315_a(u2, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(0.0, y1, 0.0).func_187315_a(u2, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x0, y1, 0.0).func_187315_a(u1, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x0, y0, 0.0).func_187315_a(u1, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(x0, y1, 0.0).func_187315_a(u1, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(0.0, y1, 0.0).func_187315_a(u2, v1).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(0.0, y0, 0.0).func_187315_a(u2, v2).func_181666_a(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GL11.glPopMatrix();
    }

    public ParticleOrientable setOrientation(Vector4 orientation) {
        this.orientation = orientation;
        return this;
    }

    @Override
    public void func_197553_a(PacketBuffer buffer) {
        super.func_197553_a(buffer);
        buffer.writeFloat(this.orientation.x);
        buffer.writeFloat(this.orientation.y);
        buffer.writeFloat(this.orientation.z);
        buffer.writeFloat(this.orientation.w);
    }
}

