/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.texturing;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thut.api.entity.IMobTexturable;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.texturing.IPartTexturer;
import thut.core.common.ThutCore;

public class TextureHelper
implements IPartTexturer {
    @CapabilityInject(value=IMobTexturable.class)
    public static final Capability<IMobTexturable> CAPABILITY = null;
    IMobTexturable mob;
    Map<String, String> texNames = Maps.newHashMap();
    Map<String, Map<String, String>> texNames2 = Maps.newHashMap();
    public ResourceLocation default_tex;
    String default_path;
    Map<String, Boolean> smoothing = Maps.newHashMap();
    boolean default_flat = true;
    Map<String, ResourceLocation> texMap = Maps.newHashMap();
    Map<String, TexState> texStates = Maps.newHashMap();
    Map<String, String> formeMap = Maps.newHashMap();

    @Override
    public void init(AnimationXML.CustomTex customTex) {
        String name;
        if (customTex == null) {
            return;
        }
        if (customTex.defaults != null) {
            this.default_path = ThutCore.trim(customTex.defaults);
        }
        if (customTex.smoothing != null) {
            boolean flat;
            this.default_flat = flat = !customTex.smoothing.equalsIgnoreCase("smooth");
        }
        this.clear();
        for (AnimationXML.TexAnim texAnim : customTex.anims) {
            name = ThutCore.trim(texAnim.part);
            String trigger = texAnim.trigger.trim();
            String[] diffs = texAnim.diffs.trim().split(",");
            TexState states = this.texStates.get(name);
            if (states == null) {
                states = new TexState();
                this.texStates.put(name, states);
            }
            states.addState(trigger, diffs);
        }
        for (AnimationXML.TexPart texPart : customTex.parts) {
            name = ThutCore.trim(texPart.name);
            String partTex = ThutCore.trim(texPart.tex);
            this.addMapping(name, partTex);
            if (texPart.smoothing == null) continue;
            boolean flat = !texPart.smoothing.equalsIgnoreCase("smooth");
            this.smoothing.put(name, flat);
        }
        for (AnimationXML.TexCustom texCustom : customTex.custom) {
            name = ThutCore.trim(texCustom.part);
            String state = ThutCore.trim(texCustom.state);
            String partTex = ThutCore.trim(texCustom.tex);
            this.addCustomMapping(name, state, partTex);
        }
        for (AnimationXML.TexForm texForm : customTex.forme) {
            name = ThutCore.trim(texForm.name);
            String tex = ThutCore.trim(texForm.tex);
            this.formeMap.put(name, tex);
        }
    }

    private void clear() {
        this.texMap.clear();
        this.texStates.clear();
        this.formeMap.clear();
        this.smoothing.clear();
        this.texNames.clear();
        this.texNames2.clear();
    }

    @Override
    public void addCustomMapping(String part, String state, String tex) {
        HashMap partMap = this.texNames2.get(part);
        if (partMap == null) {
            partMap = Maps.newHashMap();
            this.texNames2.put(part, partMap);
        }
        partMap.put(state, tex);
    }

    @Override
    public void addMapping(String part, String tex) {
        this.texNames.put(part, tex);
    }

    @Override
    public void applyTexture(String part) {
        String texMod;
        if (this.mob == null) {
            return;
        }
        if (this.bindPerState(part)) {
            return;
        }
        String defaults = this.formeMap.getOrDefault(this.mob.getForm(), this.default_path);
        String texName = ThutCore.trim(this.texNames.containsKey(part) ? this.texNames.get(part) : defaults);
        if (texName == null || texName.trim().isEmpty()) {
            this.texNames.put(part, defaults);
        }
        ResourceLocation tex = this.getResource(texName);
        TexState state = this.texStates.get(part);
        if (state != null && (texMod = state.modifyTexture(this.mob)) != null) {
            tex = this.getResource(tex.func_110623_a() + texMod);
        }
        this.bindTex(tex);
    }

    @Override
    public void bindObject(Object thing) {
        this.mob = (IMobTexturable)((ICapabilityProvider)thing).getCapability(CAPABILITY).orElse(null);
        if (this.mob != null) {
            String defaults = this.formeMap.getOrDefault(this.mob.getForm(), this.default_path);
            this.default_tex = this.getResource(defaults);
        }
    }

    private boolean bindPerState(String part) {
        Map<String, String> partNames = this.texNames2.get(part);
        if (partNames == null) {
            return false;
        }
        List<String> states = this.mob.getTextureStates();
        for (String key : partNames.keySet()) {
            String texMod;
            if (!states.contains(key)) continue;
            String texKey = part + key;
            String tex = this.texNames.get(texKey);
            if (tex == null) {
                tex = partNames.get(key);
                this.texNames.put(texKey, tex);
            }
            TexState state = this.texStates.get(part);
            if (state != null && (texMod = state.modifyTexture(this.mob)) != null) {
                tex = tex + texMod;
            }
            this.bindTex(this.getResource(tex));
            return true;
        }
        return false;
    }

    private void bindTex(ResourceLocation tex) {
        tex = this.mob.preApply(tex);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(tex);
    }

    private ResourceLocation getResource(String tex) {
        if (tex == null) {
            return this.mob.getTexture(null);
        }
        if (tex.contains(":")) {
            return new ResourceLocation(tex);
        }
        return new ResourceLocation(this.mob.getModId(), tex);
    }

    @Override
    public boolean hasMapping(String part) {
        return this.texNames.containsKey(part);
    }

    @Override
    public boolean isFlat(String part) {
        if (this.smoothing.containsKey(part)) {
            return this.smoothing.get(part);
        }
        return this.default_flat;
    }

    @Override
    public boolean shiftUVs(String part, double[] toFill) {
        if (this.mob == null) {
            return false;
        }
        TexState state = this.texStates.get(part);
        if (state != null) {
            return state.applyState(toFill, this.mob);
        }
        return false;
    }

    @Override
    public void applyTexturePhase(AnimationXML.Phase phase) {
        if (this.mob != null) {
            this.mob.applyTexturePhase(phase);
        }
    }

    private static class TexState {
        Map<String, double[]> infoStates = Maps.newHashMap();
        Set<RandomState> randomStates = Sets.newHashSet();
        SequenceState sequence = null;
        Map<Integer, RandomState> running = Maps.newHashMap();
        Map<Integer, Integer> setTimes = Maps.newHashMap();

        private TexState() {
        }

        void addState(String trigger, String[] diffs) {
            double[] arr = new double[diffs.length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = Double.parseDouble(diffs[i].trim());
            }
            if (trigger.contains("random")) {
                this.randomStates.add(new RandomState(trigger, arr));
            } else if (trigger.equals("sequence") || trigger.equals("time")) {
                this.sequence = new SequenceState(arr);
            } else if (!this.parseState(trigger, arr)) {
                new NullPointerException("No Template found for " + trigger).printStackTrace();
            }
        }

        boolean applyState(double[] toFill, IMobTexturable mob) {
            double dx = 0.0;
            double dy = 0.0;
            toFill[0] = dx;
            toFill[1] = dy;
            Random random = new Random();
            List<String> states = mob.getTextureStates();
            for (String string : states) {
                if (!this.infoStates.containsKey(string)) continue;
                double[] arr = this.infoStates.get(string);
                dx = arr[0];
                dy = arr[1];
                toFill[0] = dx;
                toFill[1] = dy;
                return true;
            }
            if (this.running.containsKey(mob.getEntity().func_145782_y())) {
                RandomState run = this.running.get(mob.getEntity().func_145782_y());
                double[] dArray = run.arr;
                dx = dArray[0];
                dy = dArray[1];
                toFill[0] = dx;
                toFill[1] = dy;
                if (mob.getEntity().field_70173_aa > this.setTimes.get(mob.getEntity().func_145782_y()) + run.duration) {
                    this.running.remove(mob.getEntity().func_145782_y());
                    this.setTimes.remove(mob.getEntity().func_145782_y());
                }
                return true;
            }
            for (RandomState randomState : this.randomStates) {
                double[] arr = randomState.arr;
                if (!((double)random.nextFloat() < randomState.chance)) continue;
                dx = arr[0];
                dy = arr[1];
                toFill[0] = dx;
                toFill[1] = dy;
                this.running.put(mob.getEntity().func_145782_y(), randomState);
                this.setTimes.put(mob.getEntity().func_145782_y(), mob.getEntity().field_70173_aa);
                return true;
            }
            if (this.sequence != null && this.sequence.shift) {
                int tick = mob.getEntity().field_70173_aa % (this.sequence.arr.length / 2);
                dx = this.sequence.arr[tick * 2];
                dy = this.sequence.arr[tick * 2 + 1];
                toFill[0] = dx;
                toFill[1] = dy;
                return true;
            }
            return false;
        }

        String modifyTexture(IMobTexturable mob) {
            if (this.sequence != null && !this.sequence.shift) {
                int tick = mob.getEntity().field_70173_aa % (this.sequence.arr.length / 2);
                int dx = (int)this.sequence.arr[tick * 2];
                return "" + dx;
            }
            return null;
        }

        private boolean parseState(String trigger, double[] arr) {
            if (trigger == null) {
                return false;
            }
            trigger = ThutCore.trim(trigger);
            this.infoStates.put(trigger, arr);
            return true;
        }
    }

    private static class SequenceState {
        double[] arr;
        boolean shift = true;

        SequenceState(double[] arr) {
            this.arr = arr;
            for (double d : arr) {
                if (!(d >= 1.0)) continue;
                this.shift = false;
            }
        }
    }

    private static class RandomState {
        double chance = 0.005;
        double[] arr;
        int duration = 1;

        RandomState(String trigger, double[] arr) {
            this.arr = arr;
            String[] args = trigger.split(":");
            if (args.length > 1) {
                this.chance = Double.parseDouble(args[1]);
            }
            if (args.length > 2) {
                this.duration = Integer.parseInt(args[2]);
            }
        }
    }
}

