/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.wrappers;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import thut.api.maths.Vector3;
import thut.api.maths.Vector4;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationHelper;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.animation.IAnimationChanger;
import thut.core.client.render.animation.ModelHolder;
import thut.core.client.render.model.IExtendedModelPart;
import thut.core.client.render.model.IModel;
import thut.core.client.render.model.IModelRenderer;
import thut.core.client.render.model.ModelFactory;
import thut.core.client.render.texturing.IRetexturableModel;

public class ModelWrapper<T extends Entity>
extends EntityModel<T>
implements IModel {
    public final ModelHolder model;
    public final IModelRenderer<?> renderer;
    public IModel imodel;
    protected float rotationPointX = 0.0f;
    protected float rotationPointY = 0.0f;
    protected float rotationPointZ = 0.0f;
    protected float rotateAngleX = 0.0f;
    protected float rotateAngleY = 0.0f;
    protected float rotateAngleZ = 0.0f;
    protected float rotateAngle = 0.0f;
    private final IModelRenderer.Vector5 rots = new IModelRenderer.Vector5();

    public ModelWrapper(ModelHolder model, IModelRenderer<?> renderer) {
        this.model = model;
        this.renderer = renderer;
    }

    @Override
    public void applyAnimation(Entity entity, CapabilityAnimation.IAnimationHolder animate, IModelRenderer<?> renderer, float partialTicks, float limbSwing) {
        this.imodel.applyAnimation(entity, animate, renderer, partialTicks, limbSwing);
    }

    @Override
    public IModel.HeadInfo getHeadInfo() {
        return this.imodel.getHeadInfo();
    }

    @Override
    public Set<String> getHeadParts() {
        return this.imodel.getHeadParts();
    }

    @Override
    public HashMap<String, IExtendedModelPart> getParts() {
        return this.imodel.getParts();
    }

    @Override
    public boolean isValid() {
        return this.imodel.isValid();
    }

    @Override
    public void preProcessAnimations(Collection<List<Animation>> collection) {
        this.imodel.preProcessAnimations(collection);
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.imodel == null) {
            this.imodel = ModelFactory.create(this.model);
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        IModel.HeadInfo info = this.imodel.getHeadInfo();
        if (info != null) {
            info.currentTick = entityIn.field_70173_aa;
        }
        IAnimationChanger animChanger = this.renderer.getAnimationChanger();
        HashSet excluded = Sets.newHashSet();
        if (animChanger != null) {
            for (String partName : this.imodel.getParts().keySet()) {
                if (!animChanger.isPartHidden(partName, entityIn, false)) continue;
                excluded.add(partName);
            }
        }
        for (String partName : this.imodel.getParts().keySet()) {
            int default_;
            int rgb;
            IExtendedModelPart part = this.imodel.getParts().get(partName);
            if (part == null) continue;
            int[] rgbab = part.getRGBAB();
            if (animChanger != null && (rgb = animChanger.getColourForPart(partName, entityIn, default_ = new Color(rgbab[0], rgbab[1], rgbab[2], rgbab[3]).getRGB())) != default_) {
                Color col = new Color(rgb);
                rgbab[0] = col.getRed();
                rgbab[1] = col.getGreen();
                rgbab[2] = col.getBlue();
            }
            part.setRGBAB(rgbab);
            try {
                if (this.renderer.getTexturer() != null) {
                    this.renderer.getTexturer().bindObject(entityIn);
                }
                if (part instanceof IRetexturableModel) {
                    ((IRetexturableModel)((Object)part)).setTexturer(this.renderer.getTexturer());
                }
                if (part.getParent() != null) continue;
                GlStateManager.pushMatrix();
                part.renderAllExcept(this.renderer, excluded.toArray(new String[excluded.size()]));
                GlStateManager.popMatrix();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
        if (info != null) {
            info.lastTick = entityIn.field_70173_aa;
        }
    }

    protected void rotate() {
        GlStateManager.rotatef((float)this.rotateAngle, (float)this.rotateAngleX, (float)this.rotateAngleY, (float)this.rotateAngleZ);
    }

    public void func_212843_a_(T entityIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        if (this.imodel == null) {
            this.imodel = ModelFactory.create(this.model);
        }
        if (this.renderer.getAnimationChanger() != null) {
            this.renderer.setAnimation(this.renderer.getAnimationChanger().modifyAnimation((MobEntity)entityIn, partialTickTime, this.renderer.getAnimation((Entity)entityIn)), (Entity)entityIn, partialTickTime);
        }
        this.applyAnimation((Entity)entityIn, AnimationHelper.getHolder(entityIn), this.renderer, partialTickTime, limbSwing);
    }

    @Override
    public void setOffset(Vector3 point) {
        this.setRotationPoint((float)point.x, (float)point.y, (float)point.z);
    }

    public void func_212844_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        IModel.HeadInfo info;
        if (this.imodel == null) {
            this.imodel = ModelFactory.create(this.model);
        }
        if ((info = this.imodel.getHeadInfo()) != null) {
            info.headPitch = headPitch;
            info.headYaw = netHeadYaw;
        }
        this.transformGlobal(this.renderer.getAnimation((Entity)entityIn), (Entity)entityIn, Minecraft.func_71410_x().func_184121_ak(), netHeadYaw, headPitch);
    }

    public void setRotationAngles(Vector4 rotations) {
        this.rotateAngle = rotations.w;
        this.rotateAngleX = rotations.x;
        this.rotateAngleY = rotations.y;
        this.rotateAngleZ = rotations.z;
    }

    public void setRotationPoint(float par1, float par2, float par3) {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }

    protected void transformGlobal(String currentPhase, Entity entity, float partialTick, float rotationYaw, float rotationPitch) {
        IModelRenderer.Vector5 rotations = this.renderer.getRotations();
        if (rotations == null) {
            rotations = this.rots;
        }
        this.setRotationAngles(rotations.rotations);
        this.setOffset(this.renderer.getRotationOffset());
        this.rotate();
        this.imodel.globalFix(this.rotationPointX, this.rotationPointY, this.rotationPointZ);
        this.translate();
        this.renderer.scaleEntity(entity, this, partialTick);
    }

    private void translate() {
        GlStateManager.translatef((float)this.rotationPointX, (float)this.rotationPointY, (float)this.rotationPointZ);
    }
}

