/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.FileAppender;
import thut.api.LinkableCaps;
import thut.api.OwnableCaps;
import thut.api.entity.IMobColourable;
import thut.api.entity.IMobTexturable;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.ShearableCaps;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.BlockEntityInventory;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.genetics.IMobGenetics;
import thut.api.terrain.CapabilityTerrain;
import thut.api.terrain.ITerrainProvider;
import thut.api.terrain.TerrainManager;
import thut.api.world.mobs.data.DataSync;
import thut.core.client.ClientProxy;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.particle.ThutParticles;
import thut.core.common.CommonProxy;
import thut.core.common.Proxy;
import thut.core.common.config.Config;
import thut.core.common.genetics.DefaultGeneStorage;
import thut.core.common.genetics.DefaultGenetics;
import thut.core.common.handlers.ConfigHandler;
import thut.core.common.mobs.DefaultColourable;
import thut.core.common.mobs.DefaultColourableStorage;
import thut.core.common.network.EntityUpdate;
import thut.core.common.network.PacketHandler;
import thut.core.common.network.TerrainUpdate;
import thut.core.common.network.TileUpdate;
import thut.core.common.world.mobs.data.DataSync_Impl;
import thut.core.common.world.mobs.data.PacketDataSync;

@Mod(value="thutcore")
public class ThutCore {
    public static final Logger LOGGER = LogManager.getLogger((String)"thutcore");
    public static final String MODID = "thutcore";
    private static final String NETVERSION = "1.0.0";
    public static final PacketHandler packets = new PacketHandler(new ResourceLocation("thutcore", "comms"), "1.0.0");
    public static ThutCore instance;
    public static final Proxy proxy;
    public static final ConfigHandler conf;
    public static ItemStack THUTICON;
    public static final ItemGroup THUTITEMS;
    private static Map<String, String> trimmed;

    public static String trim(String name) {
        if (name == null) {
            return null;
        }
        if (trimmed.containsKey(name)) {
            return trimmed.get(name);
        }
        String trim = name;
        trim = trim.toLowerCase(Locale.ROOT).trim();
        trim = trim.replaceAll("([^a-zA-Z0-9 _-])", "");
        trim = trim.replaceAll(" ", "_");
        trimmed.put(name, trim);
        return trim;
    }

    public ThutCore() {
        instance = this;
        File logfile = FMLPaths.GAMEDIR.get().resolve("logs").resolve("thutcore.log").toFile();
        if (logfile.exists()) {
            logfile.delete();
        }
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LOGGER;
        FileAppender appender = ((FileAppender.Builder)FileAppender.newBuilder().withFileName(logfile.getAbsolutePath()).setName(MODID)).build();
        logger.addAppender((Appender)appender);
        appender.start();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DataSerializers.func_187189_a(IMultiplePassengerEntity.SEATSERIALIZER);
        DataSerializers.func_187189_a(BlockEntityBase.VEC3DSER);
        Config.setupConfigs(conf, MODID, MODID);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        proxy.setupClient(event);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MODID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        LOGGER.debug("Clearing terrain cache");
        ITerrainProvider.pendingCache.clear();
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Setup");
        if (THUTICON.func_190926_b()) {
            THUTICON = new ItemStack((IItemProvider)Blocks.field_150348_b);
        }
        packets.registerMessage(EntityUpdate.class, EntityUpdate::new);
        packets.registerMessage(TileUpdate.class, TileUpdate::new);
        packets.registerMessage(TerrainUpdate.class, TerrainUpdate::new);
        packets.registerMessage(PacketDataSync.class, PacketDataSync::new);
        CapabilityManager.INSTANCE.register(IMobGenetics.class, (Capability.IStorage)new DefaultGeneStorage(), DefaultGenetics::new);
        CapabilityManager.INSTANCE.register(IMobColourable.class, (Capability.IStorage)new DefaultColourableStorage(), DefaultColourable::new);
        CapabilityManager.INSTANCE.register(IMobTexturable.class, (Capability.IStorage)new IMobTexturable.Storage(), IMobTexturable.Defaults::new);
        CapabilityAnimation.setup();
        OwnableCaps.setup();
        LinkableCaps.setup();
        ShearableCaps.setup();
        CapabilityManager.INSTANCE.register(CapabilityTerrain.ITerrainProvider.class, (Capability.IStorage)new CapabilityTerrain.Storage(), CapabilityTerrain.DefaultProvider::new);
        CapabilityManager.INSTANCE.register(DataSync.class, (Capability.IStorage)new Capability.IStorage<DataSync>(){

            public void readNBT(Capability<DataSync> capability, DataSync instance, Direction side, INBT nbt) {
            }

            public INBT writeNBT(Capability<DataSync> capability, DataSync instance, Direction side) {
                return null;
            }
        }, DataSync_Impl::new);
        TerrainManager.getInstance();
        proxy.setup(event);
    }

    static {
        proxy = (Proxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new CommonProxy());
        conf = new ConfigHandler();
        THUTICON = ItemStack.field_190927_a;
        THUTITEMS = new ItemGroup("thut"){

            public ItemStack func_78016_d() {
                return THUTICON;
            }
        };
        trimmed = Maps.newConcurrentMap();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="thutcore")
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerParticles(RegistryEvent.Register<ParticleType<?>> event) {
            LOGGER.debug("Registering Particle Types");
            event.getRegistry().register(ThutParticles.AURORA.setRegistryName(ThutCore.MODID, "aurora"));
            event.getRegistry().register(ThutParticles.LEAF.setRegistryName(ThutCore.MODID, "leaf"));
            event.getRegistry().register(ThutParticles.MISC.setRegistryName(ThutCore.MODID, "misc"));
            event.getRegistry().register(ThutParticles.STRING.setRegistryName(ThutCore.MODID, "string"));
            event.getRegistry().register(ThutParticles.POWDER.setRegistryName(ThutCore.MODID, "powder"));
        }
    }

    public static class MobEvents {
        private static final ResourceLocation CAPID = new ResourceLocation("thutcore", "inventory");

        @SubscribeEvent
        public static void onMobCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
            if (event.getCapabilities().containsKey(CAPID)) {
                return;
            }
            if (!(event.getObject() instanceof IBlockEntity)) {
                return;
            }
            event.addCapability(CAPID, (ICapabilityProvider)new BlockEntityInventory((IBlockEntity)event.getObject()));
        }

        @SubscribeEvent
        public static void interact(PlayerInteractEvent.RightClickBlock event) {
            if (event.getWorld().func_175623_d(event.getPos())) {
                PlayerEntity player = event.getPlayer();
                Vec3d face = event.getPlayer().func_174824_e(0.0f);
                Vec3d look = event.getPlayer().func_70040_Z();
                AxisAlignedBB box = event.getPlayer().func_174813_aQ().func_72314_b(3.0, 3.0, 3.0);
                EntityRayTraceResult var = ProjectileHelper.func_221269_a((World)player.func_130014_f_(), (Entity)player, (Vec3d)face, (Vec3d)look, (AxisAlignedBB)box, e -> e instanceof IBlockEntity, (double)3.0);
                if (var != null && var.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    IBlockEntity entity = (IBlockEntity)var.func_216348_a();
                    if (entity.getInteractor().processInitialInteract(event.getPlayer(), event.getItemStack(), event.getHand())) {
                        event.setCanceled(true);
                        return;
                    }
                    if (entity.getInteractor().interactInternal(event.getPlayer(), event.getPos(), event.getItemStack(), event.getHand()) != ActionResultType.PASS) {
                        event.setCanceled(true);
                        return;
                    }
                }
            }
        }
    }
}

