/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.genetics;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import thut.api.entity.genetics.Alleles;
import thut.api.entity.genetics.Gene;
import thut.api.entity.genetics.IMobGenetics;

public class DefaultGenetics
implements IMobGenetics {
    Random rand = new Random();
    Map<ResourceLocation, Alleles> genetics = Maps.newHashMap();
    Set<Alleles> epigenes;

    @Override
    public Map<ResourceLocation, Alleles> getAlleles() {
        return this.genetics;
    }

    @Override
    public Set<Alleles> getEpigenes() {
        if (this.epigenes == null) {
            this.epigenes = Sets.newHashSet();
            for (Alleles a : this.genetics.values()) {
                if (!(a.getExpressed().getEpigeneticRate() > 0.0f)) continue;
                this.epigenes.add(a);
            }
        }
        return this.epigenes;
    }

    @Override
    public void setFromParents(IMobGenetics parent1, IMobGenetics parent2) {
        Map<ResourceLocation, Alleles> genetics1 = parent1.getAlleles();
        Map<ResourceLocation, Alleles> genetics2 = parent2.getAlleles();
        for (Alleles a1 : genetics1.values()) {
            Object gene1 = a1.getExpressed();
            Alleles a2 = genetics2.get(gene1.getKey());
            if (a2 == null) continue;
            Object gene2 = a2.getExpressed();
            gene1 = gene1.getEpigeneticRate() > this.rand.nextFloat() ? gene1 : a1.getAlleles()[this.rand.nextInt(2)];
            Object object = gene2 = gene2.getEpigeneticRate() > this.rand.nextFloat() ? gene2 : a2.getAlleles()[this.rand.nextInt(2)];
            if (gene1.getMutationRate() > this.rand.nextFloat()) {
                gene1 = gene1.mutate(parent1, parent2);
            }
            if (gene2.getMutationRate() > this.rand.nextFloat()) {
                gene2 = gene2.mutate(parent1, parent2);
            }
            Alleles allele = new Alleles((Gene)gene1, (Gene)gene2);
            this.getAlleles().put(gene1.getKey(), allele);
        }
    }
}

