/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.handlers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import thut.api.boom.ExplosionCustom;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.terrain.TerrainSegment;
import thut.core.common.config.Config;
import thut.core.common.config.Configure;
import thut.core.common.terrain.ConfigTerrainBuilder;
import thut.core.common.terrain.ConfigTerrainChecker;

public class ConfigHandler
extends Config.ConfigData {
    private static final String BOOMS = "explosions";
    private static final String BIOMES = "biomes";
    private static final String BLOCKENTITY = "blockentity";
    private static final String MISC = "misc";
    @Configure(category="explosions")
    private final int explosionRadius = 127;
    @Configure(category="explosions")
    private final List<Integer> explosionRate = Lists.newArrayList((Object[])new Integer[]{2000, 10000});
    @Configure(category="explosions")
    private final boolean affectAir = true;
    @Configure(category="explosions")
    private final double minBlastEffect = 0.25;
    @Configure(category="biomes")
    public boolean resetAllTerrain = false;
    @Configure(category="biomes")
    public List<String> customBiomeMappings = Lists.newArrayList();
    @Configure(category="blockentity")
    public List<String> teblacklist = Lists.newArrayList();
    @Configure(category="blockentity")
    public List<String> blockblacklist = Lists.newArrayList((Object[])new String[]{"minecraft:bedrock"});
    @Configure(category="blockentity")
    public boolean autoBlacklistErroredTEs = true;
    @Configure(category="misc")
    public boolean debug = true;

    public ConfigHandler() {
        super("thutcore");
    }

    @Override
    public void onUpdated() {
        ExplosionCustom.MAX_RADIUS = this.explosionRadius;
        ExplosionCustom.AFFECTINAIR = this.affectAir;
        if (this.explosionRate.size() == 2) {
            ExplosionCustom.MAXPERTICK = this.explosionRate.toArray(new Integer[2]);
        }
        this.getClass();
        ExplosionCustom.MINBLASTDAMAGE = 0.25f;
        TerrainSegment.noLoad = this.resetAllTerrain;
        IBlockEntity.TEBLACKLIST.clear();
        BlockEntityUpdater.autoBlacklist = this.autoBlacklistErroredTEs;
        for (String s : this.teblacklist) {
            if (!s.contains(":")) {
                s = "minecraft:" + s;
            }
            IBlockEntity.TEBLACKLIST.add(s);
            IBlockEntity.TEBLACKLIST.add(s.toLowerCase(Locale.ENGLISH));
        }
        for (String s : this.blockblacklist) {
            IBlockEntity.BLOCKBLACKLIST.add(new ResourceLocation(s));
        }
        TerrainSegment.biomeCheckers.removeIf(t -> t instanceof ConfigTerrainChecker);
        ConfigTerrainBuilder.process(this.customBiomeMappings);
    }
}

