/*
 * Decompiled with CFR 0.152.
 */
package thut.crafts.client;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thut.api.entity.blockentity.render.RenderBlockEntity;
import thut.api.maths.Vector3;
import thut.crafts.CommonProxy;
import thut.crafts.ThutCrafts;
import thut.crafts.entity.CraftController;
import thut.crafts.entity.EntityCraft;
import thut.crafts.network.PacketCraftControl;

public class ClientProxy
extends CommonProxy {
    KeyBinding UP;
    KeyBinding DOWN;
    KeyBinding ROTATERIGHT;
    KeyBinding ROTATELEFT;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.PlayerTickEvent event) {
        Entity e;
        if (event.phase == TickEvent.Phase.START || event.player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        if (event.player.func_184218_aH() && Minecraft.func_71410_x().field_71462_r == null && (e = event.player.func_184187_bx()) instanceof EntityCraft) {
            ClientPlayerEntity player = (ClientPlayerEntity)event.player;
            CraftController controller = ((EntityCraft)e).controller;
            if (controller != null) {
                controller.backInputDown = player.field_71158_b.field_187256_d;
                controller.forwardInputDown = player.field_71158_b.field_187255_c;
                controller.leftInputDown = player.field_71158_b.field_187257_e;
                controller.rightInputDown = player.field_71158_b.field_187258_f;
                controller.upInputDown = this.UP.func_151470_d();
                controller.downInputDown = this.DOWN.func_151470_d();
                if (ThutCrafts.conf.canRotate) {
                    controller.rightRotateDown = this.ROTATERIGHT.func_151470_d();
                    controller.leftRotateDown = this.ROTATELEFT.func_151470_d();
                }
                PacketCraftControl.sendControlPacket(e, controller);
            }
        }
    }

    @Override
    public PlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void RenderBounds(DrawBlockHighlightEvent event) {
        if (!(event.getTarget() instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult target = (BlockRayTraceResult)event.getTarget();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack held = player.func_184614_ca();
        if (!held.func_190926_b() || !(held = player.func_184592_cb()).func_190926_b()) {
            BlockPos pos = target.func_216350_a();
            if (pos == null || held.func_77973_b() != ThutCrafts.CRAFTMAKER) {
                return;
            }
            if (!player.field_70170_p.func_180495_p(pos).func_185904_a().func_76220_a()) {
                Vec3d loc = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a(2.0));
                pos = new BlockPos(loc);
            }
            if (held.func_77978_p() != null && held.func_77978_p().func_74764_b("min")) {
                BlockPos min = Vector3.readFromNBT(held.func_77978_p().func_74775_l("min"), "").getPos();
                BlockPos max = pos;
                AxisAlignedBB box = new AxisAlignedBB(min, max);
                min = new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c);
                max = new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_177982_a(1, 1, 1);
                box = new AxisAlignedBB(min, max);
                float partialTicks = event.getPartialTicks();
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                box = box.func_72317_d(-d0, -d1 - (double)player.func_70047_e(), -d2);
                GlStateManager.enableBlend();
                GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                GlStateManager.lineWidth((float)2.0f);
                GlStateManager.disableTexture();
                GlStateManager.depthMask((boolean)false);
                GlStateManager.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer = tessellator.func_178180_c();
                vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181675_d();
                tessellator.func_78381_a();
                vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181675_d();
                tessellator.func_78381_a();
                vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181675_d();
                vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.depthMask((boolean)true);
                GlStateManager.enableTexture();
                GlStateManager.disableBlend();
            }
        }
    }

    @Override
    public void setup(FMLCommonSetupEvent event) {
        super.setup(event);
    }

    @Override
    public void setupClient(FMLClientSetupEvent event) {
        this.UP = new KeyBinding("crafts.key.up", 32, "keys.crafts");
        this.DOWN = new KeyBinding("crafts.key.down", 341, "keys.crafts");
        KeyConflictContext inGame = KeyConflictContext.IN_GAME;
        this.UP.setKeyConflictContext((IKeyConflictContext)inGame);
        this.DOWN.setKeyConflictContext((IKeyConflictContext)inGame);
        this.ROTATERIGHT = new KeyBinding("crafts.key.left", 93, "keys.crafts");
        this.ROTATELEFT = new KeyBinding("crafts.key.right", 91, "keys.crafts");
        this.ROTATELEFT.setKeyConflictContext((IKeyConflictContext)inGame);
        this.ROTATERIGHT.setKeyConflictContext((IKeyConflictContext)inGame);
        ClientRegistry.registerKeyBinding((KeyBinding)this.UP);
        ClientRegistry.registerKeyBinding((KeyBinding)this.DOWN);
        ClientRegistry.registerKeyBinding((KeyBinding)this.ROTATELEFT);
        ClientRegistry.registerKeyBinding((KeyBinding)this.ROTATERIGHT);
        RenderingRegistry.registerEntityRenderingHandler(EntityCraft.class, manager -> new RenderBlockEntity(manager));
    }
}

