/*
 * Decompiled with CFR 0.152.
 */
package thut.crafts.entity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.maths.vecmath.Vector3f;
import thut.crafts.entity.EntityCraft;

public class CraftInteractHandler
extends BlockEntityInteractHandler {
    final EntityCraft craft;

    public CraftInteractHandler(EntityCraft lift) {
        super(lift);
        this.craft = lift;
    }

    @Override
    public ActionResultType applyPlayerInteraction(PlayerEntity player, Vec3d vec, ItemStack stack, Hand hand) {
        if (player.func_70093_af()) {
            return ActionResultType.PASS;
        }
        ActionResultType result = super.applyPlayerInteraction(player, vec, stack, hand);
        if (result == ActionResultType.SUCCESS || this.processInitialInteract(player, player.func_184586_b(hand), hand)) {
            return ActionResultType.SUCCESS;
        }
        vec = vec.func_72441_c(vec.field_72450_a > 0.0 ? -0.01 : 0.01, vec.field_72448_b > 0.0 ? -0.01 : 0.01, vec.field_72449_c > 0.0 ? -0.01 : 0.01);
        Vec3d playerPos = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d start = playerPos.func_178788_d(this.craft.func_174791_d());
        RayTraceResult hit = IBlockEntity.BlockEntityFormer.rayTraceInternal(start.func_178787_e(this.craft.func_174791_d()), vec.func_178787_e(this.craft.func_174791_d()), this.craft);
        BlockRayTraceResult trace = hit instanceof BlockRayTraceResult ? (BlockRayTraceResult)hit : null;
        BlockPos pos = trace == null ? this.craft.func_180425_c() : trace.func_216350_a();
        if (trace != null && this.interactInternal(player, pos, stack, hand) == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        if (this.craft.field_70177_z != 0.0f) {
            for (int i = 0; i < this.craft.getSeatCount(); ++i) {
                IMultiplePassengerEntity.Seat seat = this.craft.getSeat(i);
                if (this.craft.field_70170_p.field_72995_K || !seat.getEntityId().equals(IMultiplePassengerEntity.Seat.BLANK)) continue;
                this.craft.setSeatID(i, player.func_110124_au());
                player.func_184220_m((Entity)this.craft);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public ActionResultType interactInternal(PlayerEntity player, BlockPos pos, ItemStack stack, Hand hand) {
        BlockState state = this.craft.getFakeWorld().getBlock(pos);
        if (state != null && state.func_177230_c() instanceof StairsBlock) {
            if (this.craft.getSeatCount() == 0) {
                BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
                int xMin = this.craft.getMin().func_177958_n();
                int zMin = this.craft.getMin().func_177952_p();
                int yMin = this.craft.getMin().func_177956_o();
                int sizeX = this.craft.getTiles().length;
                int sizeY = this.craft.getTiles()[0].length;
                int sizeZ = this.craft.getTiles()[0][0].length;
                for (int i = 0; i < sizeX; ++i) {
                    for (int j = 0; j < sizeY; ++j) {
                        for (int k = 0; k < sizeZ; ++k) {
                            pos1.func_189532_c((double)(i + xMin) + this.craft.field_70165_t, (double)(j + yMin) + this.craft.field_70163_u, (double)(k + zMin) + this.craft.field_70161_v);
                            BlockState state1 = this.craft.getFakeWorld().getBlock((BlockPos)pos1);
                            if (!(state1.func_177230_c() instanceof StairsBlock)) continue;
                            Vector3f seat = new Vector3f(i + xMin, (float)(j + yMin) + 0.5f, k + zMin);
                            this.craft.addSeat(seat);
                        }
                    }
                }
            }
            BlockPos pos2 = new BlockPos(this.craft.func_174791_d());
            pos = pos.func_177973_b((Vec3i)pos2);
            for (int i = 0; i < this.craft.getSeatCount(); ++i) {
                IMultiplePassengerEntity.Seat seat = this.craft.getSeat(i);
                Vector3f seatPos = seat.seat;
                BlockPos pos1 = new BlockPos((double)seatPos.x, (double)seatPos.y, (double)seatPos.z);
                if (!pos1.equals((Object)pos)) continue;
                if (player.func_130014_f_().field_72995_K || seat.getEntityId().equals(player.func_110124_au())) break;
                this.craft.setSeatID(i, player.func_110124_au());
                player.func_184220_m((Entity)this.craft);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean processInitialInteract(PlayerEntity player, @Nullable ItemStack stack, Hand hand) {
        if (stack.func_77973_b() == Items.field_151072_bj && !player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("msg.craft.killed", new Object[0]));
            this.craft.func_70106_y();
            return true;
        }
        return false;
    }
}

