/*
 * Decompiled with CFR 0.152.
 */
package thut.api;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.OwnableCaps;
import thut.api.ThutCaps;
import thut.api.maths.Vector4;

public class LinkableCaps {
    public static void setup() {
        CapabilityManager.INSTANCE.register(ILinkable.class, (Capability.IStorage)new LinkStore(), Linkable::new);
        CapabilityManager.INSTANCE.register(ILinkStorage.class, (Capability.IStorage)new StoreStore(), LinkStorage::new);
        MinecraftForge.EVENT_BUS.register(OwnableCaps.class);
    }

    @SubscribeEvent
    public static void linkBlock(PlayerInteractEvent.RightClickBlock event) {
        LazyOptional test_tile;
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        LazyOptional test_stack = event.getItemStack().getCapability(ThutCaps.STORE, event.getFace());
        if (!test_stack.isPresent()) {
            return;
        }
        ILinkStorage storage = (ILinkStorage)test_stack.orElse(null);
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        if (tile != null && (test_tile = tile.getCapability(ThutCaps.LINK, event.getFace())).isPresent()) {
            ((ILinkable)test_tile.orElse(null)).link(storage, (Entity)event.getPlayer());
            event.setCanceled(true);
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
        } else {
            Vector4 loc = new Vector4(event.getPos(), event.getPlayer().field_71093_bK);
            storage.setLinkedPos(loc, (Entity)event.getPlayer());
            event.setCanceled(true);
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
        }
    }

    private static class StoreStore
    implements Capability.IStorage<ILinkStorage> {
        private StoreStore() {
        }

        public void readNBT(Capability<ILinkStorage> capability, ILinkStorage instance, Direction side, INBT nbt) {
        }

        public INBT writeNBT(Capability<ILinkStorage> capability, ILinkStorage instance, Direction side) {
            return null;
        }
    }

    private static class LinkStore
    implements Capability.IStorage<ILinkable> {
        private LinkStore() {
        }

        public void readNBT(Capability<ILinkable> capability, ILinkable instance, Direction side, INBT nbt) {
        }

        public INBT writeNBT(Capability<ILinkable> capability, ILinkable instance, Direction side) {
            return null;
        }
    }

    public static class Linkable
    implements ILinkable,
    ICapabilityProvider {
        private final LazyOptional<ILinkable> holder = LazyOptional.of(() -> this);
        LinkStorage store = new LinkStorage();

        @Override
        public boolean link(ILinkStorage link, Entity user) {
            this.store.setLinkedMob(link.getLinkedMob(user), user);
            this.store.setLinkedPos(link.getLinkedPos(user), user);
            return true;
        }

        @Override
        public ILinkStorage getLink(Entity user) {
            return this.store;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.LINK.orEmpty(cap, this.holder);
        }
    }

    public static class LinkStorage
    implements ILinkStorage,
    ICapabilityProvider {
        private final LazyOptional<ILinkStorage> holder = LazyOptional.of(() -> this);
        UUID uuid;
        Vector4 pos;

        @Override
        public UUID getLinkedMob(Entity user) {
            return this.uuid;
        }

        @Override
        public Vector4 getLinkedPos(Entity user) {
            return this.pos;
        }

        @Override
        public boolean setLinkedMob(UUID mobid, Entity user) {
            this.uuid = mobid;
            return true;
        }

        @Override
        public boolean setLinkedPos(Vector4 pos, Entity user) {
            this.pos = pos;
            return true;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.STORE.orEmpty(cap, this.holder);
        }
    }

    public static interface ILinkable {
        public boolean link(ILinkStorage var1, @Nullable Entity var2);

        @Nonnull
        public ILinkStorage getLink(@Nullable Entity var1);
    }

    public static interface ILinkStorage {
        @Nullable
        public UUID getLinkedMob(Entity var1);

        @Nullable
        public Vector4 getLinkedPos(Entity var1);

        public boolean setLinkedMob(@Nullable UUID var1, @Nullable Entity var2);

        public boolean setLinkedPos(@Nullable Vector4 var1, @Nullable Entity var2);
    }
}

