/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.ThutCaps;
import thut.api.entity.IBreedingMob;

public class BreedableCaps {
    public static final ResourceLocation WRAP = new ResourceLocation("thutcore:breedable_wrap");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void attachMobs(AttachCapabilitiesEvent<Entity> event) {
        for (ICapabilityProvider p : event.getCapabilities().values()) {
            if (!p.getCapability(ThutCaps.BREEDS).isPresent()) continue;
            return;
        }
        if (event.getObject() instanceof AgeableEntity) {
            event.addCapability(WRAP, (ICapabilityProvider)new AgeableWrapper((AgeableEntity)event.getObject()));
        }
    }

    public static IBreedingMob getBreedable(ICapabilityProvider in) {
        if (in == null) {
            return null;
        }
        return (IBreedingMob)in.getCapability(ThutCaps.BREEDS).orElse(null);
    }

    public static void setup() {
        CapabilityManager.INSTANCE.register(IBreedingMob.class, (Capability.IStorage)new Storage(), Impl::new);
        MinecraftForge.EVENT_BUS.register(BreedableCaps.class);
    }

    public static class Storage
    implements Capability.IStorage<IBreedingMob> {
        public void readNBT(Capability<IBreedingMob> capability, IBreedingMob instance, Direction side, INBT nbt) {
            if (instance instanceof ICapabilitySerializable) {
                ((ICapabilitySerializable)instance).deserializeNBT(nbt);
            }
        }

        public INBT writeNBT(Capability<IBreedingMob> capability, IBreedingMob instance, Direction side) {
            if (instance instanceof ICapabilitySerializable) {
                return ((ICapabilitySerializable)instance).serializeNBT();
            }
            return null;
        }
    }

    public static class AgeableWrapper
    extends Impl {
        final AgeableEntity wrapped;

        public AgeableWrapper(AgeableEntity wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Object getChild(IBreedingMob male) {
            return this.wrapped.func_90011_a(male.getEntity());
        }

        @Override
        public boolean canMate(AgeableEntity other) {
            if (this.wrapped instanceof AnimalEntity && other instanceof AnimalEntity) {
                return ((AnimalEntity)this.wrapped).func_70878_b((AnimalEntity)other);
            }
            return other.getClass() == this.wrapped.getClass();
        }

        @Override
        public boolean canBreed() {
            if (this.wrapped instanceof AnimalEntity) {
                return ((AnimalEntity)this.wrapped).func_204701_dC();
            }
            return super.canBreed();
        }

        @Override
        public boolean isBreeding() {
            if (this.wrapped instanceof AnimalEntity) {
                return ((AnimalEntity)this.wrapped).func_70880_s();
            }
            return super.isBreeding();
        }

        @Override
        public void setReadyToMate(@Nullable PlayerEntity cause) {
            if (this.wrapped instanceof AnimalEntity) {
                ((AnimalEntity)this.wrapped).func_146082_f(cause);
            }
        }

        @Override
        public void resetLoveStatus() {
            if (this.wrapped instanceof AnimalEntity) {
                ((AnimalEntity)this.wrapped).func_70875_t();
            }
        }

        @Override
        public ServerPlayerEntity getCause() {
            if (this.wrapped instanceof AnimalEntity) {
                return ((AnimalEntity)this.wrapped).func_191993_do();
            }
            return super.getCause();
        }
    }

    public static class Impl
    implements IBreedingMob,
    ICapabilityProvider {
        private final LazyOptional<IBreedingMob> holder = LazyOptional.of(() -> this);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.BREEDS.orEmpty(cap, this.holder);
        }

        @Override
        public AgeableEntity getEntity() {
            return null;
        }
    }
}

