/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.maths.Vector4;

public class ThutTeleporter {
    public static void transferTo(Entity entity, Vector4 dest) {
        ThutTeleporter.transferTo(entity, dest, false);
    }

    public static void transferTo(Entity entity, Vector4 dest, boolean sound) {
        if (entity.func_130014_f_() instanceof ServerWorld) {
            if (dest.w == (float)entity.field_71093_bK.func_186068_a()) {
                ThutTeleporter.moveMob(entity, dest);
                return;
            }
            ServerWorld destWorld = entity.func_184102_h().func_71218_a(DimensionType.func_186069_a((int)((int)dest.w)));
            if (entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                player.field_184851_cj = true;
                player.func_200619_a(destWorld, (double)dest.x, (double)dest.y, (double)dest.z, entity.field_70177_z, entity.field_70125_A);
                if (sound) {
                    destWorld.func_184134_a((double)dest.x, (double)dest.y, (double)dest.z, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
                player.field_184851_cj = false;
            } else {
                new TransferTicker(destWorld, entity, dest, sound);
            }
        }
    }

    private static void transferMob(ServerWorld destWorld, Vector4 dest, Entity entity) {
        ServerPlayerEntity player = null;
        if (entity instanceof ServerPlayerEntity) {
            player = (ServerPlayerEntity)entity;
            player.field_184851_cj = true;
        }
        ServerWorld serverworld = (ServerWorld)entity.func_130014_f_();
        entity.field_71093_bK = destWorld.field_73011_w.func_186058_p();
        ThutTeleporter.removeMob(serverworld, entity, true);
        entity.revive();
        entity.func_70012_b((double)dest.x, (double)dest.y, (double)dest.z, entity.field_70177_z, entity.field_70125_A);
        entity.func_70029_a((World)destWorld);
        ThutTeleporter.addMob(destWorld, entity);
        if (player != null) {
            player.field_184851_cj = false;
            player.field_71135_a.func_184342_d();
            player.field_71135_a.func_147364_a((double)dest.x, (double)dest.y, (double)dest.z, entity.field_70177_z, entity.field_70125_A);
        }
    }

    private static void addMob(ServerWorld world, Entity entity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entity, (World)world))) {
            return;
        }
        IChunk ichunk = world.func_217353_a(MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0)), MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0)), ChunkStatus.field_222617_m, true);
        if (ichunk instanceof Chunk) {
            ichunk.func_76612_a(entity);
        }
        world.func_217440_f(entity);
    }

    private static void removeMob(ServerWorld world, Entity entity, boolean keepData) {
        entity.remove(keepData);
        world.removeEntity(entity, keepData);
    }

    private static void moveMob(Entity entity, Vector4 dest) {
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147364_a((double)dest.x, (double)dest.y, (double)dest.z, entity.field_70177_z, entity.field_70125_A);
            ((ServerPlayerEntity)entity).field_71135_a.func_184342_d();
        } else {
            entity.func_70012_b((double)dest.x, (double)dest.y, (double)dest.z, entity.field_70177_z, entity.field_70125_A);
        }
    }

    private static class TransferTicker {
        private final Entity entity;
        private final ServerWorld destWorld;
        private final Vector4 dest;
        private final boolean sound;

        public TransferTicker(ServerWorld destWorld, Entity entity, Vector4 dest, boolean sound) {
            this.entity = entity;
            this.dest = dest;
            this.sound = sound;
            this.destWorld = destWorld;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void TickEvent(TickEvent.WorldTickEvent event) {
            if (event.world == this.entity.func_130014_f_() && event.phase == TickEvent.Phase.END) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                ThutTeleporter.transferMob(this.destWorld, this.dest, this.entity);
                if (this.sound) {
                    this.destWorld.func_184134_a((double)this.dest.x, (double)this.dest.y, (double)this.dest.z, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    this.entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                }
            }
        }
    }
}

