/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.ai;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import org.apache.logging.log4j.Level;
import thut.api.entity.ai.IAIRunnable;
import thut.core.common.ThutCore;

public class GoalsWrapper
extends Goal {
    public final List<IAIRunnable> wrapped;
    private final Entity mob;
    private int lastTick = -1;

    public GoalsWrapper(Entity mob, IAIRunnable ... wrap) {
        this.wrapped = Lists.newArrayList((Object[])wrap);
        this.wrapped.sort((a, b) -> a.getPriority() - b.getPriority());
        this.mob = mob;
    }

    private boolean canRun(IAIRunnable task) {
        int prior = task.getPriority();
        int mutex = task.getMutex();
        for (int i = 0; i < this.wrapped.size(); ++i) {
            IAIRunnable ai = this.wrapped.get(i);
            if (ai.getPriority() >= prior || (mutex & ai.getMutex()) == 0 || !ai.shouldRun()) continue;
            return false;
        }
        return task.shouldRun();
    }

    public void func_75251_c() {
    }

    public boolean func_75253_b() {
        return true;
    }

    public boolean func_75250_a() {
        return true;
    }

    public void func_75249_e() {
    }

    public void func_75246_d() {
        if (this.lastTick == this.mob.field_70173_aa) {
            return;
        }
        this.lastTick = this.mob.field_70173_aa;
        for (IAIRunnable ai : this.wrapped) {
            try {
                if (this.canRun(ai)) {
                    ai.run();
                    ai.tick();
                    ai.finish();
                    continue;
                }
                ai.reset();
            }
            catch (Exception e) {
                ThutCore.LOGGER.log(Level.FATAL, "error checking task " + ai, (Throwable)e);
            }
        }
    }
}

