/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thut.api.entity.blockentity.IBlockEntity;

public abstract class BlockEntityInteractHandler {
    final IBlockEntity blockEntity;
    final Entity theEntity;
    protected BlockRayTraceResult trace;

    public BlockEntityInteractHandler(IBlockEntity entity) {
        this.blockEntity = entity;
        this.theEntity = (Entity)entity;
    }

    public BlockRayTraceResult getLastTrace() {
        return this.trace;
    }

    public ActionResultType applyPlayerInteraction(PlayerEntity player, Vec3d vec, ItemStack stack, Hand hand) {
        World world;
        Vec3d playerPos;
        Vec3d start = playerPos = player.func_174824_e(1.0f);
        Vec3d end = playerPos.func_178787_e(player.func_70040_Z().func_186678_a(4.5));
        this.trace = null;
        RayTraceResult trace2 = IBlockEntity.BlockEntityFormer.rayTraceInternal(start, end, this.blockEntity);
        if (trace2 instanceof BlockRayTraceResult) {
            this.trace = (BlockRayTraceResult)trace2;
        }
        World realWorld = this.theEntity.func_130014_f_();
        World world2 = world = this.blockEntity.getFakeWorld() instanceof World ? (World)this.blockEntity.getFakeWorld() : realWorld;
        if (this.trace != null) {
            switch (this.trace.func_216346_c()) {
                case BLOCK: {
                    BlockState state = this.blockEntity.getFakeWorld().getBlock(this.trace.func_216350_a());
                    return state.func_227031_a_(world, player, hand, this.trace);
                }
                case ENTITY: {
                    break;
                }
                case MISS: {
                    RayTraceContext context = new RayTraceContext(start, end, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player);
                    trace2 = realWorld.func_217299_a(context);
                    if (!(trace2 instanceof BlockRayTraceResult)) break;
                    BlockState state = realWorld.func_180495_p(((BlockRayTraceResult)trace2).func_216350_a());
                    return state.func_227031_a_(realWorld, player, hand, (BlockRayTraceResult)trace2);
                }
            }
        }
        return ActionResultType.PASS;
    }

    public abstract ActionResultType interactInternal(PlayerEntity var1, BlockPos var2, @Nullable ItemStack var3, Hand var4);

    public boolean processInitialInteract(PlayerEntity player, @Nullable ItemStack stack, Hand hand) {
        return false;
    }
}

