/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import thut.api.TickHandler;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.entity.blockentity.world.IBlockEntityWorld;

public class BlockEntityUpdater {
    public static boolean autoBlacklist = false;
    final IBlockEntity blockEntity;
    final Entity theEntity;
    List<AxisAlignedBB> blockBoxes = Lists.newArrayList();
    Set<TileEntity> erroredSet = Sets.newHashSet();
    VoxelShape totalShape = VoxelShapes.func_197880_a();

    public static boolean isWhitelisted(TileEntity tile) {
        ResourceLocation id = TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C());
        return id == null ? true : !IBlockEntity.TEBLACKLIST.contains(id.toString());
    }

    public BlockEntityUpdater(IBlockEntity rocket) {
        this.blockEntity = rocket;
        this.theEntity = (Entity)rocket;
    }

    public VoxelShape buildShape() {
        int sizeX = this.blockEntity.getBlocks().length;
        int sizeY = this.blockEntity.getBlocks()[0].length;
        int sizeZ = this.blockEntity.getBlocks()[0][0].length;
        Entity mob = (Entity)this.blockEntity;
        this.totalShape = VoxelShapes.func_197880_a();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        BlockPos min = this.blockEntity.getMin();
        BlockPos origin = mob.func_180425_c();
        IBlockEntityWorld world = this.blockEntity.getFakeWorld();
        int xMin = MathHelper.func_76141_d((float)this.blockEntity.getMin().func_177958_n());
        int xMax = MathHelper.func_76141_d((float)this.blockEntity.getMax().func_177958_n());
        int zMin = MathHelper.func_76141_d((float)this.blockEntity.getMin().func_177952_p());
        int zMax = MathHelper.func_76141_d((float)this.blockEntity.getMax().func_177952_p());
        double dx = (double)((xMax - xMin) / 2) + 0.5;
        double dz = (double)((zMax - zMin) / 2) + 0.5;
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    VoxelShape shape;
                    pos.func_181079_c(i, j, k);
                    BlockState state = this.blockEntity.getBlocks()[i][j][k];
                    pos.func_181079_c(i + min.func_177958_n() + origin.func_177958_n(), j + min.func_177956_o() + origin.func_177956_o(), k + min.func_177952_p() + origin.func_177952_p());
                    if (state == null || (shape = state.func_196954_c((IBlockReader)world, (BlockPos)pos)) == null || shape.func_197766_b()) continue;
                    shape = shape.func_197751_a(mob.func_226277_ct_() + (double)i - dx, mob.func_226278_cu_() + (double)j + (double)min.func_177956_o(), mob.func_226281_cx_() + (double)k - dz);
                    this.totalShape = VoxelShapes.func_197878_a((VoxelShape)this.totalShape, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
            }
        }
        return this.totalShape;
    }

    private static double getIntersect(double minA, double minB, double minC, double maxA, double maxB, double maxC) {
        boolean min_min;
        if (minC != minA && minC != maxA && maxC != minA && maxC != maxA) {
            return 0.0;
        }
        double dmax_max = maxA - maxB;
        double dmax_min = maxA - minB;
        double dmin_max = minA - maxB;
        double dmin_min = minA - minB;
        boolean max_max = maxA == maxB;
        boolean max_min = maxA == minB;
        boolean min_max = minA == maxB;
        boolean bl = min_min = minA == minB;
        if (min_min && MathHelper.func_219806_b((double)minB, (double)minC)) {
            min_min = false;
        }
        if (max_max && MathHelper.func_219806_b((double)maxB, (double)maxC)) {
            max_max = false;
        }
        if (max_min && MathHelper.func_219806_b((double)maxB, (double)minC)) {
            max_min = false;
        }
        if (min_max && MathHelper.func_219806_b((double)minB, (double)maxC)) {
            min_max = false;
        }
        if (!(min_min || max_max || max_min || min_max)) {
            return 0.0;
        }
        double intersectAmount = 0.0;
        if (min_min) {
            intersectAmount = dmax_min;
        }
        if (max_max) {
            intersectAmount = dmin_max;
        }
        if (max_min) {
            intersectAmount = -dmax_max;
        }
        if (min_max) {
            intersectAmount = -dmin_min;
        }
        return intersectAmount;
    }

    private static double getIntersect(Direction.Axis axis, AxisAlignedBB boxA, AxisAlignedBB boxB, AxisAlignedBB boxC) {
        switch (axis) {
            case X: {
                return BlockEntityUpdater.getIntersect(boxA.field_72340_a, boxB.field_72340_a, boxC.field_72340_a, boxA.field_72336_d, boxB.field_72336_d, boxC.field_72336_d);
            }
            case Y: {
                return BlockEntityUpdater.getIntersect(boxA.field_72338_b, boxB.field_72338_b, boxC.field_72338_b, boxA.field_72337_e, boxB.field_72337_e, boxC.field_72337_e);
            }
            case Z: {
                return BlockEntityUpdater.getIntersect(boxA.field_72339_c, boxB.field_72339_c, boxC.field_72339_c, boxA.field_72334_f, boxB.field_72334_f, boxC.field_72334_f);
            }
        }
        return 0.0;
    }

    public static boolean intersectsOrAdjacent(AxisAlignedBB boxA, AxisAlignedBB boxB) {
        return boxA.field_72340_a <= boxB.field_72336_d && boxA.field_72336_d >= boxB.field_72340_a && boxA.field_72338_b <= boxB.field_72337_e && boxA.field_72337_e >= boxB.field_72338_b && boxA.field_72339_c <= boxB.field_72334_f && boxA.field_72334_f >= boxB.field_72339_c;
    }

    public void applyEntityCollision(Entity entity) {
        boolean collided;
        AxisAlignedBB toUse;
        if ((this.theEntity.field_70177_z + 360.0f) % 90.0f > 5.0f || this.theEntity.func_184196_w(entity)) {
            return;
        }
        boolean serverSide = entity.func_130014_f_().field_72995_K;
        boolean isPlayer = entity instanceof PlayerEntity;
        if (isPlayer) {
            serverSide = entity instanceof ServerPlayerEntity;
        }
        double dx = 0.0;
        double dz = 0.0;
        double dy = 0.0;
        Vec3d motion_a = this.theEntity.func_213322_ci();
        Vec3d motion_b = entity.func_213322_ci();
        AxisAlignedBB boundingBox = entity.func_174813_aQ();
        if (isPlayer && serverSide) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            dx = player.field_71094_bP - player.field_71091_bM;
            dy = player.field_71095_bQ - player.field_71096_bN;
            dz = player.field_71085_bR - player.field_71097_bO;
            motion_b = new Vec3d(dx, dy, dz).func_186678_a(0.5);
        }
        Vec3d diffV = motion_a.func_178788_d(motion_b);
        AxisAlignedBB testBox = boundingBox.func_72321_a(diffV.field_72450_a, diffV.field_72448_b, diffV.field_72449_c);
        this.blockBoxes.clear();
        AxisAlignedBB hitTest = testBox.func_186662_g(0.1 + diffV.func_72433_c());
        this.buildShape().func_197755_b((x0, y0, z0, x1, y1, z1) -> {
            AxisAlignedBB box = new AxisAlignedBB(x0, y0, z0, x1, y1, z1);
            if (BlockEntityUpdater.intersectsOrAdjacent(box, hitTest)) {
                this.blockBoxes.add(box);
            }
        });
        boolean colX = false;
        boolean colY = false;
        boolean colZ = false;
        dx = 0.0;
        dy = 0.0;
        dz = 0.0;
        AxisAlignedBB orig = toUse = testBox;
        for (AxisAlignedBB aabb : this.blockBoxes) {
            boolean max;
            double dx1 = 0.0;
            double dy1 = 0.0;
            double dz1 = 0.0;
            if (!BlockEntityUpdater.intersectsOrAdjacent(aabb, toUse)) continue;
            AxisAlignedBB inter = toUse.func_191500_a(aabb);
            if (inter.func_216360_c() == 0.0 && inter.field_72338_b == aabb.field_72337_e) {
                colY = true;
            }
            if (inter.func_216364_b() == 0.0 || inter.func_216360_c() == 0.0 || inter.func_216362_d() == 0.0) continue;
            dx1 = BlockEntityUpdater.getIntersect(Direction.Axis.X, inter, toUse, aabb);
            dy1 = BlockEntityUpdater.getIntersect(Direction.Axis.Y, inter, toUse, aabb);
            dz1 = BlockEntityUpdater.getIntersect(Direction.Axis.Z, inter, toUse, aabb);
            if (dx1 != 0.0 && dz1 != 0.0) {
                boolean bl = max = Math.abs(dx1) > Math.abs(dz1);
                if (max) {
                    dx1 = 0.0;
                } else {
                    dz1 = 0.0;
                }
            }
            if (dy1 != 0.0 && dx1 != 0.0) {
                boolean bl = max = Math.abs(dx1) > Math.abs(dy1);
                if (max) {
                    dx1 = 0.0;
                } else {
                    dy1 = 0.0;
                }
            }
            if (dy1 != 0.0 && dz1 != 0.0) {
                boolean bl = max = Math.abs(dz1) > Math.abs(dy1);
                if (max) {
                    dz1 = 0.0;
                } else {
                    dy1 = 0.0;
                }
            }
            if (dy1 == 0.0 && (dz1 != 0.0 || dx1 != 0.0) && (dy = inter.field_72337_e - toUse.field_72338_b) >= 0.0 && dy < (double)entity.field_70138_W) {
                boolean valid = true;
                for (AxisAlignedBB aabb2 : this.blockBoxes) {
                    if (aabb2 == aabb || !aabb2.func_72326_a(toUse)) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    dx1 = 0.0;
                    dz1 = 0.0;
                    dy1 = dy;
                }
            }
            colX = colX || dx1 != 0.0;
            colY = colY || dy1 != 0.0;
            colZ = colZ || dz1 != 0.0;
            toUse = toUse.func_72317_d(dx1, dy1, dz1);
        }
        dx = toUse.field_72340_a - orig.field_72340_a;
        dy = toUse.field_72338_b - orig.field_72338_b;
        dz = toUse.field_72339_c - orig.field_72339_c;
        boolean bl = collided = colX || colY || colZ;
        if (collided) {
            Vec3d motion;
            motion_b = entity.func_213322_ci();
            if (colY) {
                motion = new Vec3d(0.0, dy, 0.0);
                entity.func_213315_a(MoverType.SELF, motion);
                dy = motion_a.field_72448_b;
            } else {
                dy = motion_b.field_72448_b;
            }
            if (colX) {
                motion = new Vec3d(dx, 0.0, 0.0);
                entity.func_213315_a(MoverType.SELF, motion);
                dx = motion_a.field_72450_a;
            } else {
                dx = 0.9 * motion_b.field_72450_a;
            }
            if (colZ) {
                motion = new Vec3d(0.0, 0.0, dz);
                entity.func_213315_a(MoverType.SELF, motion);
                dz = motion_a.field_72449_c;
            } else {
                dz = 0.9 * motion_b.field_72449_c;
            }
            entity.func_213293_j(dx, dy, dz);
            if (colY) {
                entity.field_70122_E = true;
                entity.func_225503_b_(entity.field_70143_R, 0.0f);
                entity.field_70143_R = 0.0f;
            }
        }
        if (isPlayer && (collided || motion_a.field_72448_b < 0.0)) {
            PlayerEntity player = (PlayerEntity)entity;
            if (serverSide) {
                ServerPlayerEntity serverplayer = (ServerPlayerEntity)player;
                serverplayer.field_71135_a.field_184346_E = 0;
                serverplayer.field_71135_a.field_147365_f = 0;
            }
            if (!serverSide && (Minecraft.func_71410_x().field_71474_y.field_74336_f || TickHandler.playerTickTracker.containsKey(player.func_110124_au()))) {
                TickHandler.playerTickTracker.put(player.func_110124_au(), (int)(System.currentTimeMillis() % 2000L));
                Minecraft.func_71410_x().field_71474_y.field_74336_f = false;
            }
            if (!serverSide) {
                player.getPersistentData().func_74768_a("lastStandTick", player.field_70173_aa);
            }
        }
    }

    public void onSetPosition() {
        double xMin = this.theEntity.field_70165_t + (double)this.blockEntity.getMin().func_177958_n() - 0.5;
        double yMin = this.theEntity.field_70163_u + (double)this.blockEntity.getMin().func_177956_o();
        double zMin = this.theEntity.field_70161_v + (double)this.blockEntity.getMin().func_177952_p() - 0.5;
        double xMax = this.theEntity.field_70165_t + (double)this.blockEntity.getMax().func_177958_n() + 0.5;
        double yMax = this.theEntity.field_70163_u + (double)this.blockEntity.getMax().func_177956_o() + 1.0;
        double zMax = this.theEntity.field_70161_v + (double)this.blockEntity.getMax().func_177952_p() + 0.5;
        this.theEntity.func_174826_a(new AxisAlignedBB(xMin, yMin, zMin, xMax, yMax, zMax));
    }

    public void onUpdate() {
        if (this.blockEntity.getBlocks() == null) {
            return;
        }
        double wMax = this.theEntity.func_130014_f_().getMaxEntityRadius();
        double uMax = -1.0;
        if (wMax < (double)this.blockEntity.getBlocks().length) {
            uMax = this.blockEntity.getBlocks().length;
        }
        if (wMax < (double)this.blockEntity.getBlocks()[0].length) {
            uMax = this.blockEntity.getBlocks()[0].length;
        }
        if (wMax < (double)this.blockEntity.getBlocks()[0][0].length) {
            uMax = this.blockEntity.getBlocks()[0][0].length;
        }
        this.theEntity.func_130014_f_().increaseMaxEntityRadius(uMax);
        EntitySize size = this.theEntity.func_213305_a(this.theEntity.func_213283_Z());
        size = EntitySize.func_220311_c((float)(1 + this.blockEntity.getMax().func_177958_n() - this.blockEntity.getMin().func_177958_n()), (float)this.blockEntity.getMax().func_177956_o());
        this.blockEntity.setSize(size);
        if (this.theEntity.func_213322_ci().field_72448_b == 0.0) {
            double y = Math.round(this.theEntity.func_226278_cu_());
            if (this.theEntity.func_226278_cu_() != y) {
                this.theEntity.func_70107_b(this.theEntity.func_226277_ct_(), y, this.theEntity.func_226281_cx_());
            }
        }
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int xMin = this.blockEntity.getMin().func_177958_n();
        int zMin = this.blockEntity.getMin().func_177952_p();
        int yMin = this.blockEntity.getMin().func_177956_o();
        int sizeX = this.blockEntity.getTiles().length;
        int sizeY = this.blockEntity.getTiles()[0].length;
        int sizeZ = this.blockEntity.getTiles()[0][0].length;
        World world = this.blockEntity.getFakeWorld() instanceof World ? (World)this.blockEntity.getFakeWorld() : this.theEntity.func_130014_f_();
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeY; ++j) {
                for (int k = 0; k < sizeZ; ++k) {
                    pos.func_189532_c((double)(i + xMin) + this.theEntity.func_226277_ct_(), (double)(j + yMin) + this.theEntity.func_226278_cu_(), (double)(k + zMin) + this.theEntity.func_226281_cx_());
                    TileEntity tile = this.blockEntity.getTiles()[i][j][k];
                    if (tile != null) {
                        tile.func_226984_a_(world, pos.func_185334_h());
                    }
                    if (!(tile instanceof ITickableTileEntity) || this.erroredSet.contains(tile) || !BlockEntityUpdater.isWhitelisted(tile)) continue;
                    try {
                        ((ITickableTileEntity)tile).func_73660_a();
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        System.err.println("Error with Tile Entity " + tile);
                        this.erroredSet.add(tile);
                        if (!autoBlacklist || TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C()) == null) continue;
                        IBlockEntity.TEBLACKLIST.add(TileEntityType.func_200969_a((TileEntityType)tile.func_200662_C()).toString());
                    }
                }
            }
        }
    }
}

