/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import thut.api.entity.IMultiplePassengerEntity;
import thut.api.entity.blockentity.BlockEntityBase;
import thut.api.entity.blockentity.IBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class RenderBlockEntity<T extends BlockEntityBase>
extends EntityRenderer<T> {
    private static IBakedModel crate_model;
    static final Tessellator t;
    float pitch = 0.0f;
    float yaw = 0.0f;
    long time = 0L;
    boolean up = true;
    BufferBuilder b = t.func_178180_c();
    ResourceLocation texture;

    public RenderBlockEntity(EntityRendererManager manager) {
        super(manager);
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack mat, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (!(entity instanceof IBlockEntity)) {
            return;
        }
        try {
            mat.func_227860_a_();
            BlockPos.Mutable pos = new BlockPos.Mutable();
            T blockEntity = entity;
            int xMin = MathHelper.func_76141_d((float)blockEntity.getMin().func_177958_n());
            int xMax = MathHelper.func_76141_d((float)blockEntity.getMax().func_177958_n());
            int zMin = MathHelper.func_76141_d((float)blockEntity.getMin().func_177952_p());
            int zMax = MathHelper.func_76141_d((float)blockEntity.getMax().func_177952_p());
            int yMin = MathHelper.func_76141_d((float)blockEntity.getMin().func_177956_o());
            int yMax = MathHelper.func_76141_d((float)blockEntity.getMax().func_177956_o());
            double dx = (double)((xMax - xMin) / 2) + 0.5;
            double dz = (double)((zMax - zMin) / 2) + 0.5;
            mat.func_227861_a_(-dx, 0.0, -dz);
            mat.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(180.0f));
            mat.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            mat.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            if (entity instanceof IMultiplePassengerEntity) {
                IMultiplePassengerEntity multi = (IMultiplePassengerEntity)entity;
                float yaw = -(multi.getPrevYaw() + (multi.getYaw() - multi.getPrevYaw()) * partialTicks);
                float pitch = -(multi.getPrevPitch() + (multi.getPitch() - multi.getPrevPitch()) * partialTicks);
                mat.func_227863_a_(new Quaternion(0.0f, yaw, pitch, true));
            }
            for (int i = xMin; i <= xMax; ++i) {
                for (int j = yMin; j <= yMax; ++j) {
                    for (int k = zMin; k <= zMax; ++k) {
                        pos.func_181079_c(i - xMin, j - yMin, k - zMin);
                        if (!blockEntity.shouldHide((BlockPos)pos)) {
                            mat.func_227860_a_();
                            mat.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                            this.drawTileAt((BlockPos)pos, (IBlockEntity)blockEntity, partialTicks, mat, bufferIn, packedLightIn);
                            this.drawBlockAt((BlockPos)pos, (IBlockEntity)blockEntity, mat, bufferIn, packedLightIn);
                            mat.func_227865_b_();
                            continue;
                        }
                        this.drawCrateAt(pos, (IBlockEntity)blockEntity, mat, bufferIn, packedLightIn);
                    }
                }
            }
            mat.func_227865_b_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawBlockAt(BlockPos pos, IBlockEntity entity, MatrixStack mat, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entity.getBlocks() == null) {
            return;
        }
        BlockState state = entity.getBlocks()[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()];
        BlockPos mobPos = entity.getMin();
        BlockPos realpos = pos.func_177971_a((Vec3i)mobPos).func_177971_a((Vec3i)((Entity)entity).func_180425_c());
        if (state == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        World world = ((Entity)entity).func_130014_f_();
        if (state.func_185904_a() != Material.field_151579_a) {
            world = (World)entity.getFakeWorld();
            BlockState actualstate = state.func_177230_c().getExtendedState(state, (IBlockReader)entity.getFakeWorld(), pos);
            this.renderBakedBlockModel(entity, actualstate, (IBlockReader)world, realpos, pos, mat, bufferIn, packedLightIn);
        }
    }

    private void drawCrateAt(BlockPos.Mutable pos, IBlockEntity blockEntity, MatrixStack mat, IRenderTypeBuffer bufferIn, int packedLightIn) {
        mat.func_227860_a_();
        mat.func_227863_a_(new Quaternion(-180.0f, 90.0f, 0.0f, true));
        mat.func_227861_a_(0.5, 0.5, 0.5);
        RenderHelper.func_74518_a();
        float f7 = 1.0f;
        mat.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.func_177068_d().field_78724_e.func_110577_a(PlayerContainer.field_226615_c_);
        this.getCrateModel();
        RenderHelper.func_227780_a_();
        mat.func_227865_b_();
    }

    private void drawTileAt(BlockPos pos, IBlockEntity entity, float partialTicks, MatrixStack mat, IRenderTypeBuffer bufferIn, int packedLightIn) {
        TileEntity tile = entity.getTiles()[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()];
        if (tile != null) {
            TileEntityRendererDispatcher.field_147556_a.func_228850_a_(tile, partialTicks, mat, bufferIn);
        }
    }

    private IBakedModel getCrateModel() {
        if (crate_model == null) {
            ModelResourceLocation loc = new ModelResourceLocation("thutcore:craft_crate");
            crate_model = Minecraft.func_71410_x().func_209506_al().getModel((ResourceLocation)loc);
        }
        return crate_model;
    }

    public ResourceLocation getEntityTexture(T entity) {
        return PlayerContainer.field_226615_c_;
    }

    private void renderBakedBlockModel(IBlockEntity entity, BlockState state, IBlockReader world, BlockPos real_pos, BlockPos relPos, MatrixStack mat, IRenderTypeBuffer bufferIn, int packedLightIn) {
        IModelData data = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state).getModelData((ILightReader)world, real_pos, state, (IModelData)EmptyModelData.INSTANCE);
        BlockPos rpos = relPos.func_177971_a((Vec3i)entity.getOriginalPos());
        for (RenderType type : RenderType.func_228661_n_()) {
            if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
            BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
            IBakedModel model = blockRenderer.func_184389_a(state);
            blockRenderer.func_175019_b().renderModel((ILightReader)world, model, state, real_pos, mat, bufferIn.getBuffer(type), false, new Random(), state.func_209533_a(rpos), packedLightIn, data);
        }
    }

    static {
        t = new Tessellator(0x200000);
    }
}

