/*
 * Decompiled with CFR 0.152.
 */
package thut.api.inventory.big;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.INBTSerializable;
import thut.api.inventory.big.Manager;

public abstract class BigInventory
implements IInventory,
INBTSerializable<CompoundNBT> {
    UUID id;
    int page = 0;
    private final boolean isReal;
    public boolean[] opened;
    public String[] boxes;
    Manager<? extends BigInventory> manager;
    private final Int2ObjectOpenHashMap<ItemStack> contents = new Int2ObjectOpenHashMap();

    public BigInventory(Manager<? extends BigInventory> manager, UUID id) {
        this.boxes = new String[this.boxCount()];
        for (int i = 0; i < this.boxCount(); ++i) {
            this.boxes[i] = "Box " + String.valueOf(i + 1);
        }
        this.opened = new boolean[this.boxCount()];
        this.id = id;
        this.contents.defaultReturnValue((Object)ItemStack.field_190927_a);
        this.manager = manager;
        this.isReal = true;
    }

    public BigInventory(Manager<? extends BigInventory> manager, CompoundNBT tag) {
        this.boxes = new String[this.boxCount()];
        for (int i = 0; i < this.boxCount(); ++i) {
            this.boxes[i] = "Box " + String.valueOf(i + 1);
        }
        this.opened = new boolean[this.boxCount()];
        this.contents.defaultReturnValue((Object)ItemStack.field_190927_a);
        this.manager = manager;
        this.deserializeNBT(tag);
        this.isReal = true;
    }

    public BigInventory(Manager<? extends BigInventory> manager, PacketBuffer buffer) {
        this.boxes = new String[this.boxCount()];
        for (int i = 0; i < this.boxCount(); ++i) {
            this.boxes[i] = "Box " + String.valueOf(i + 1);
        }
        this.opened = new boolean[this.boxCount()];
        this.contents.defaultReturnValue((Object)ItemStack.field_190927_a);
        this.manager = manager;
        if (buffer != null) {
            this.deserializeNBT(buffer.func_150793_b());
        }
        this.isReal = false;
    }

    public PacketBuffer makeBuffer() {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer((int)0));
        CompoundNBT boxInfo = new CompoundNBT();
        this.serializeBoxInfo(boxInfo);
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("boxes", (INBT)boxInfo);
        tag.func_74757_a("Real", false);
        buffer.func_150786_a(tag);
        return buffer;
    }

    public void addItem(ItemStack stack) {
        int i;
        for (i = this.getPage() * 54; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.func_70299_a(i, stack);
            return;
        }
        for (i = 0; i < this.getPage() * 54; ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.func_70299_a(i, stack);
            return;
        }
    }

    public abstract int boxCount();

    public void func_174888_l() {
        this.contents.clear();
    }

    public void func_174886_c(PlayerEntity player) {
        if (this.isReal) {
            this.manager.save(this.id);
        }
    }

    public ItemStack func_70298_a(int i, int j) {
        if (!((ItemStack)this.contents.get(i)).func_190926_b()) {
            ItemStack itemstack = ((ItemStack)this.contents.get(i)).func_77979_a(j);
            if (((ItemStack)this.contents.get(i)).func_190926_b()) {
                this.contents.remove(i);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void deserializeBox(CompoundNBT nbt) {
        int start;
        for (int i = start = nbt.func_74762_e("box") * 54; i < start + 54; ++i) {
            CompoundNBT CompoundNBT2;
            short j;
            this.func_70299_a(i, ItemStack.field_190927_a);
            if (!nbt.func_74764_b("item" + i) || (j = (CompoundNBT2 = nbt.func_74775_l("item" + i)).func_74765_d("Slot")) < start || j >= start + 54) continue;
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)CompoundNBT2);
            this.func_70299_a(j, itemstack);
        }
    }

    public void deserializeBoxInfo(CompoundNBT boxes) {
        String id = boxes.func_74779_i("UUID");
        this.id = UUID.fromString(id);
        for (int k = 0; k < this.boxCount(); ++k) {
            if (k == 0) {
                this.setPage(boxes.func_74762_e("page"));
            }
            if (boxes.func_74779_i("name" + k) == null) continue;
            this.boxes[k] = boxes.func_74779_i("name" + k);
        }
    }

    public void deserializeItems(CompoundNBT nbt) {
        this.contents.clear();
        for (String key : nbt.func_150296_c()) {
            CompoundNBT CompoundNBT2;
            short j;
            if (!key.startsWith("item") || (j = (CompoundNBT2 = nbt.func_74775_l(key)).func_74765_d("Slot")) < 0 || j >= this.func_70302_i_() || this.contents.containsKey((int)j)) continue;
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)CompoundNBT2);
            this.func_70299_a(j, itemstack);
        }
    }

    public void deserializeNBT(CompoundNBT nbt) {
        CompoundNBT boxes = nbt.func_74775_l("boxes");
        this.deserializeBoxInfo(boxes);
        this.deserializeItems(nbt);
    }

    public ItemStack func_70301_a(int i) {
        ItemStack stack = (ItemStack)this.contents.get(i);
        if (stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    public boolean func_191420_l() {
        return true;
    }

    public UUID getOwner() {
        return this.id;
    }

    public boolean func_94041_b(int par1, ItemStack stack) {
        return this.manager.isItemValid(stack);
    }

    public boolean func_70300_a(PlayerEntity PlayerEntity2) {
        return true;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public ItemStack func_70304_b(int i) {
        ItemStack stack = (ItemStack)this.contents.remove(i);
        if (stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    public CompoundNBT serializeBox(int box) {
        int start;
        CompoundNBT items = new CompoundNBT();
        items.func_74768_a("box", box);
        for (int i = start = box * 54; i < start + 54; ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            if (itemstack.func_190926_b()) continue;
            CompoundNBT2.func_74777_a("Slot", (short)i);
            itemstack.func_77955_b(CompoundNBT2);
            items.func_218657_a("item" + i, (INBT)CompoundNBT2);
        }
        return items;
    }

    public void serializeBoxInfo(CompoundNBT boxes) {
        boxes.func_74778_a("UUID", this.id.toString());
        boxes.func_74768_a("page", this.page);
        for (int i = 0; i < this.boxCount(); ++i) {
            boxes.func_74778_a("name" + i, this.boxes[i]);
        }
    }

    public void serializeItems(CompoundNBT items) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            CompoundNBT CompoundNBT2 = new CompoundNBT();
            if (itemstack.func_190926_b()) continue;
            CompoundNBT2.func_74777_a("Slot", (short)i);
            itemstack.func_77955_b(CompoundNBT2);
            items.func_218657_a("item" + i, (INBT)CompoundNBT2);
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT items = new CompoundNBT();
        CompoundNBT boxes = new CompoundNBT();
        this.serializeBoxInfo(boxes);
        this.serializeItems(items);
        items.func_218657_a("boxes", (INBT)boxes);
        return items;
    }

    public int func_70302_i_() {
        return this.boxCount() * 54;
    }

    public int getPage() {
        return this.page;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (!itemstack.func_190926_b()) {
            this.contents.put(i, (Object)itemstack);
        } else {
            this.contents.remove(i);
        }
    }

    public void setPage(int page) {
        this.page = page;
    }

    public static interface LoadFactory<T> {
        public T create(Manager<?> var1, CompoundNBT var2);
    }

    public static interface NewFactory<T> {
        public T create(Manager<?> var1, UUID var2);
    }
}

