/*
 * Decompiled with CFR 0.152.
 */
package thut.api.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.brigadier.StringReader;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import thut.api.maths.Vector4;
import thut.api.maths.vecmath.Vector3f;
import thut.api.particle.ParticleBase;

public class ParticleOrientable
extends ParticleBase {
    public Vector4 orientation;

    public ParticleOrientable(int x, int y) {
        super(x, y);
        this.billboard = false;
    }

    @Override
    protected ParticleBase read(StringReader reader) {
        super.read(reader);
        return this;
    }

    @Override
    public ParticleBase read(PacketBuffer buffer) {
        super.read(buffer);
        this.orientation = new Vector4(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderParticle(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks, Vector3f offset) {
        Quaternion quaternion = new Quaternion(renderInfo.func_227995_f_());
        quaternion.func_195890_a(this.orientation.toMCQ());
        this.render(buffer, quaternion, offset);
    }

    public ParticleOrientable setOrientation(Vector4 orientation) {
        this.orientation = orientation;
        return this;
    }

    @Override
    public void func_197553_a(PacketBuffer buffer) {
        super.func_197553_a(buffer);
        buffer.writeFloat(this.orientation.x);
        buffer.writeFloat(this.orientation.y);
        buffer.writeFloat(this.orientation.z);
        buffer.writeFloat(this.orientation.w);
    }
}

