/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import java.util.HashMap;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeType;
import thut.core.common.ThutCore;

public class BiomeDatabase {
    public static HashMap<Biome, BiomeDictionary.Type[]> biomeTypes = new HashMap();

    public static boolean contains(Biome b, BiomeDictionary.Type type) {
        return BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)type);
    }

    public static BiomeType getBiome(Biome b) {
        if (b != null && ThutCore.trim(BiomeDatabase.getBiomeName(b)).contains("flower")) {
            return BiomeType.FLOWER;
        }
        return BiomeType.NONE;
    }

    public static String getBiome(World world, Vector3 v, boolean checkIndandVillage) {
        ServerWorld server;
        String ret = "";
        if (checkIndandVillage && world instanceof ServerWorld && (server = (ServerWorld)world).func_217483_b_(v.getPos())) {
            return "village";
        }
        Biome biome = v.getBiome((IWorld)world);
        ret = BiomeDatabase.getBiome((Biome)biome).name;
        return ret;
    }

    public static String getBiomeName(Biome biome) {
        return biome.getRegistryName().func_110624_b();
    }

    public static String getUnlocalizedNameFromType(int type) {
        return BiomeType.getType((int)type).readableName;
    }
}

