/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import thut.api.ThutCaps;
import thut.api.terrain.BiomeType;
import thut.api.terrain.TerrainSegment;

public class CapabilityTerrain {

    public static class Storage
    implements Capability.IStorage<ITerrainProvider> {
        public void readNBT(Capability<ITerrainProvider> capability, ITerrainProvider instance, Direction side, INBT base) {
            if (instance instanceof DefaultProvider && base instanceof CompoundNBT) {
                ((DefaultProvider)instance).deserializeNBT((CompoundNBT)base);
            }
        }

        public INBT writeNBT(Capability<ITerrainProvider> capability, ITerrainProvider instance, Direction side) {
            if (instance instanceof DefaultProvider) {
                return ((DefaultProvider)instance).serializeNBT();
            }
            return null;
        }
    }

    public static interface ITerrainProvider {
        public BlockPos getChunkPos();

        public TerrainSegment getTerrainSegement(BlockPos var1);

        public TerrainSegment getTerrainSegment(int var1);

        public void setTerrainSegment(TerrainSegment var1, int var2);

        public ITerrainProvider setChunk(IChunk var1);
    }

    public static class DefaultProvider
    implements ITerrainProvider,
    ICapabilityProvider,
    INBTSerializable<CompoundNBT> {
        private final LazyOptional<ITerrainProvider> holder = LazyOptional.of(() -> this);
        private BlockPos pos;
        private IChunk chunk;
        private final TerrainSegment[] segments = new TerrainSegment[16];

        public DefaultProvider() {
            this.chunk = null;
        }

        public DefaultProvider(IChunk chunk) {
            this.chunk = chunk;
        }

        @Override
        public ITerrainProvider setChunk(IChunk chunk) {
            this.chunk = chunk;
            return this;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            BlockPos pos = this.getChunkPos();
            int x = pos.func_177958_n();
            int z = pos.func_177952_p();
            HashMap idReplacements = Maps.newHashMap();
            ListNBT tags = (ListNBT)nbt.func_74781_a("ids");
            for (int i = 0; i < tags.size(); ++i) {
                CompoundNBT tag = tags.func_150305_b(i);
                String name = tag.func_74779_i("name");
                int id = tag.func_74762_e("id");
                BiomeType type = BiomeType.getBiome(name, false);
                if (type.getType() == id) continue;
                idReplacements.put(id, type.getType());
            }
            boolean hasReplacements = !idReplacements.isEmpty();
            for (int i = 0; i < 16; ++i) {
                CompoundNBT terrainTag = null;
                try {
                    terrainTag = nbt.func_74775_l(i + "");
                }
                catch (Exception id) {
                    // empty catch block
                }
                TerrainSegment t = null;
                if (terrainTag != null && !terrainTag.isEmpty() && !TerrainSegment.noLoad) {
                    t = new TerrainSegment(x, i, z);
                    if (hasReplacements) {
                        t.idReplacements = idReplacements;
                    }
                    TerrainSegment.readFromNBT(t, terrainTag);
                    this.setTerrainSegment(t, i);
                    t.idReplacements = null;
                }
                if (t != null) continue;
                t = new TerrainSegment(x, i, z);
                this.setTerrainSegment(t, i);
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return ThutCaps.TERRAIN_CAP.orEmpty(cap, this.holder);
        }

        @Override
        public BlockPos getChunkPos() {
            if (this.pos == null) {
                this.pos = new BlockPos(this.chunk.func_76632_l().field_77276_a, 0, this.chunk.func_76632_l().field_77275_b);
            }
            return this.pos;
        }

        @Override
        public TerrainSegment getTerrainSegement(BlockPos blockLocation) {
            int chunkY = blockLocation.func_177956_o();
            TerrainSegment segment = this.getTerrainSegment(chunkY);
            return segment;
        }

        @Override
        public TerrainSegment getTerrainSegment(int chunkY) {
            BlockPos pos = new BlockPos(this.chunk.func_76632_l().field_77276_a, chunkY &= 0xF, this.chunk.func_76632_l().field_77275_b);
            TerrainSegment ret = this.segments[chunkY];
            TerrainSegment cached = thut.api.terrain.ITerrainProvider.removeCached(this.chunk.getWorldForge().func_201675_m().func_186058_p(), pos);
            if (ret == null) {
                ret = cached != null ? (this.segments[chunkY] = cached) : (this.segments[chunkY] = new TerrainSegment(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            } else if (cached != null) {
                for (int i = 0; i < cached.biomes.length; ++i) {
                    if (ret.biomes[i] != -1) continue;
                    ret.biomes[i] = cached.biomes[i];
                }
            }
            ret.chunk = this.chunk;
            ret.real = true;
            return ret;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            for (int i = 0; i < 16; ++i) {
                TerrainSegment t = this.getTerrainSegment(i);
                if (t == null) continue;
                t.checkToSave();
                if (!t.toSave) continue;
                CompoundNBT terrainTag = new CompoundNBT();
                t.saveToNBT(terrainTag);
                nbt.func_218657_a("" + i, (INBT)terrainTag);
            }
            ListNBT biomeList = new ListNBT();
            for (BiomeType t : BiomeType.values()) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("name", t.name);
                tag.func_74768_a("id", t.getType());
                biomeList.add((Object)tag);
            }
            nbt.func_218657_a("ids", (INBT)biomeList);
            return nbt;
        }

        @Override
        public void setTerrainSegment(TerrainSegment segment, int chunkY) {
            this.segments[chunkY &= 0xF] = segment;
        }
    }
}

