/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thut.api.maths.Vector3;
import thut.api.terrain.CapabilityTerrain;
import thut.api.terrain.ITerrainProvider;
import thut.api.terrain.TerrainSegment;

public class TerrainManager {
    public static final ResourceLocation TERRAINCAP = new ResourceLocation("thutcore", "terrain");
    private static TerrainManager terrain;
    public ITerrainProvider provider = new ITerrainProvider(){};

    public static void clear() {
    }

    public static TerrainManager getInstance() {
        if (terrain == null) {
            terrain = new TerrainManager();
        }
        return terrain;
    }

    public static boolean isAreaLoaded(IWorld world, Vector3 centre, double distance) {
        return TerrainManager.isAreaLoaded(world, centre.getPos(), distance);
    }

    public static boolean isAreaLoaded(IWorld world, BlockPos blockPos, double distance) {
        DimensionType dim = null;
        if (world != null && world.func_201675_m() != null) {
            dim = world.func_201675_m().func_186058_p();
        }
        return TerrainManager.isAreaLoaded(dim, blockPos, distance);
    }

    public static boolean isAreaLoaded(DimensionType dim, BlockPos blockPos, double distance) {
        if (dim == null) {
            return false;
        }
        int r = (int)distance >> 4;
        int x = blockPos.func_177958_n() >> 4;
        int z = blockPos.func_177952_p() >> 4;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                ChunkPos pos = new ChunkPos(x + i, z + j);
                if (TerrainManager.chunkIsReal(dim, pos)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean chunkIsReal(IWorld world, BlockPos blockPos) {
        return TerrainManager.chunkIsReal(world, new ChunkPos(blockPos));
    }

    public static boolean chunkIsReal(IWorld world, ChunkPos pos) {
        DimensionType dim = null;
        if (world != null && world.func_201675_m() != null) {
            dim = world.func_201675_m().func_186058_p();
        }
        return TerrainManager.chunkIsReal(dim, pos);
    }

    public static boolean chunkIsReal(DimensionType dim, ChunkPos pos) {
        if (dim == null) {
            return false;
        }
        return ITerrainProvider.getChunk(dim, pos) != null;
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load evt) {
        DimensionType dim = null;
        if (evt.getWorld() != null && evt.getWorld().func_201675_m() != null) {
            dim = evt.getWorld().func_201675_m().func_186058_p();
        }
        if (dim != null) {
            ITerrainProvider.addChunk(dim, evt.getChunk());
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload evt) {
        DimensionType dim = null;
        if (evt.getWorld() != null && evt.getWorld().func_201675_m() != null) {
            dim = evt.getWorld().func_201675_m().func_186058_p();
        }
        if (dim != null) {
            ITerrainProvider.removeChunk(dim, evt.getChunk().func_76632_l());
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload evt) {
    }

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<Chunk> event) {
        if (event.getCapabilities().containsKey(TERRAINCAP)) {
            return;
        }
        Chunk chunk = (Chunk)event.getObject();
        CapabilityTerrain.DefaultProvider terrain = new CapabilityTerrain.DefaultProvider((IChunk)chunk);
        event.addCapability(TERRAINCAP, (ICapabilityProvider)terrain);
    }

    public TerrainSegment getTerrain(IWorld world, BlockPos p) {
        return this.provider.getTerrain(world, p);
    }

    public TerrainSegment getTerrain(IWorld world, double x, double y, double z) {
        BlockPos pos = new BlockPos(x, y, z);
        TerrainSegment ret = this.getTerrain(world, pos);
        if (world instanceof ServerWorld) {
            ret.initBiomes(world);
        }
        return ret;
    }

    public TerrainSegment getTerrainForEntity(Entity e) {
        if (e == null) {
            return null;
        }
        return this.getTerrain((IWorld)e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public TerrainSegment getTerrian(IWorld world, Vector3 v) {
        return this.getTerrain(world, v.x, v.y, v.z);
    }
}

