/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import thut.core.client.render.animation.Animation;
import thut.core.client.render.animation.AnimationXML;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.animation.IAnimationChanger;

public class AnimationRandomizer
implements IAnimationChanger {
    Map<String, List<RandomAnimation>> sets = Maps.newHashMap();
    Map<String, Set<LoadedAnimSet>> loadedSets = Maps.newHashMap();
    Set<String> allAnims = Sets.newHashSet();
    Map<String, Set<String>> reversed = Maps.newHashMap();
    CapabilityAnimation.IAnimationHolder currentHolder = null;

    public AnimationRandomizer(List<AnimationXML.SubAnim> anims) {
        for (AnimationXML.SubAnim a : anims) {
            this.allAnims.add(a.base);
            this.allAnims.add(a.name);
            HashSet sets = this.loadedSets.get(a.base);
            if (sets == null) {
                sets = Sets.newHashSet();
                this.loadedSets.put(a.base, sets);
            }
            LoadedAnimSet set = new LoadedAnimSet();
            set.name = a.name;
            set.weight = a.weight;
            Set<String> parents = this.reversed.getOrDefault(a.name, Sets.newHashSet());
            parents.add(a.base);
            this.reversed.put(a.name, parents);
            sets.add(set);
        }
    }

    @Override
    public void reset() {
        this.sets.clear();
        this.allAnims.clear();
        this.loadedSets.clear();
        this.reversed.clear();
    }

    private void addAnimationSet(Animation animation, String parent) {
        ArrayList anims = this.sets.get(parent);
        if (anims == null) {
            anims = Lists.newArrayList();
            this.sets.put(parent, anims);
        }
        anims.add(new RandomAnimation(animation));
    }

    @Override
    public void addChild(IAnimationChanger randomizer) {
    }

    @Override
    public IAnimationChanger.WornOffsets getOffsets(String part) {
        return null;
    }

    @Override
    public boolean hasAnimation(String phase) {
        return this.allAnims.contains(phase);
    }

    @Override
    public void init(Set<Animation> existingAnimations) {
        HashSet animations = Sets.newHashSet();
        for (Animation existing : existingAnimations) {
            if (!this.loadedSets.containsKey(existing.name)) continue;
            animations.add(existing.name);
        }
        for (String s : animations) {
            Set<LoadedAnimSet> set = this.loadedSets.get(s);
            block2: for (LoadedAnimSet loaded : set) {
                for (Animation anim : existingAnimations) {
                    if (!anim.name.equals(loaded.name)) continue;
                    for (int i = 0; i < loaded.weight; ++i) {
                        this.addAnimationSet(anim, s);
                    }
                    continue block2;
                }
            }
        }
    }

    @Override
    public boolean getAlternates(List<String> toFill, Set<String> options, Entity mob, String phase) {
        if (this.sets.containsKey(phase)) {
            CapabilityAnimation.IAnimationHolder holder = this.getAnimationHolder();
            if (holder != null && !holder.getPlaying().isEmpty() && holder.getPendingAnimations().equals(phase)) {
                return true;
            }
            List<RandomAnimation> set = this.sets.get(phase);
            int rand = new Random(System.nanoTime()).nextInt(set.size());
            RandomAnimation anim = set.get(rand);
            AnimationSet aSet = new AnimationSet(anim);
            toFill.add(aSet.anim.name);
            return true;
        }
        return false;
    }

    @Override
    public void parseDyeables(Set<String> set) {
    }

    @Override
    public void parseShearables(Set<String> set) {
    }

    @Override
    public void parseWornOffsets(Map<String, IAnimationChanger.WornOffsets> map) {
    }

    @Override
    public CapabilityAnimation.IAnimationHolder getAnimationHolder() {
        return this.currentHolder;
    }

    @Override
    public void setAnimationHolder(CapabilityAnimation.IAnimationHolder holder) {
        this.currentHolder = holder;
    }

    private static class RandomAnimation {
        final String name;

        public RandomAnimation(Animation animation) {
            this.name = animation.name;
        }
    }

    private static class LoadedAnimSet {
        String name;
        int weight;

        private LoadedAnimSet() {
        }
    }

    private static class AnimationSet {
        final RandomAnimation anim;

        public AnimationSet(RandomAnimation anim) {
            this.anim = anim;
        }
    }
}

